"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplainCollectionInterval = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _blurbs = require("../../blurbs");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ExplainCollectionInterval extends _react.default.Component {
  constructor(props) {
    super(props);
    this.handleClick = this.handleClick.bind(this);
  }
  handleClick() {
    const {
      enabler
    } = this.props;
    enabler.enableCollectionInterval();
  }
  render() {
    const {
      reason,
      isCollectionIntervalUpdated,
      isCollectionIntervalUpdating
    } = this.props;
    const {
      context,
      property,
      data
    } = reason;
    const renderButton = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_blurbs.WhatIs, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      size: "half"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.explanations.collectionIntervalDescription",
      defaultMessage: "We checked the {context} settings and found that {property} is set to {data}.",
      values: {
        context,
        property: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, property),
        data: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, data)
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.explanations.collectionInterval.wrongIntervalValueDescription",
      defaultMessage: "The collection interval setting needs to be a positive integer (10s is recommended) in order for the collection agents to be active."
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.explanations.collectionInterval.changeIntervalDescription",
      defaultMessage: "Would you like us to change it and enable monitoring?"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceAround",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: this.handleClick,
      type: "button",
      "data-test-subj": "enableCollectionInterval",
      isLoading: isCollectionIntervalUpdating
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.explanations.collectionInterval.turnOnMonitoringButtonLabel",
      defaultMessage: "Turn on monitoring"
    })))));
    const renderSuccess = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.explanations.collectionInterval.monitoringTurnedOnTitle",
      defaultMessage: "Success! Wait a moment please."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      size: "half"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.explanations.collectionInterval.monitoringTurnedOnDescription",
      defaultMessage: "As soon as monitoring data appears in your cluster the page will automatically refresh with your monitoring dashboard. This only takes only a few seconds."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l"
    }));

    // prettier-ignore
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isCollectionIntervalUpdated ? renderSuccess() : renderButton());
  }
}
exports.ExplainCollectionInterval = ExplainCollectionInterval;
ExplainCollectionInterval.propTypes = {
  enabler: _propTypes.default.object.isRequired,
  reason: _propTypes.default.object.isRequired,
  isCollectionIntervalUpdated: _propTypes.default.bool,
  isCollectionIntervalUpdating: _propTypes.default.bool
};