"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Statement = Statement;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _plugin_statement = require("../models/pipeline/plugin_statement");
var _collapsible_statement = require("./collapsible_statement");
var _if_element = require("../models/list/if_element");
var _plugin_statement2 = require("./plugin_statement");
require("./statement.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function renderStatementName(name, onVertexSelected) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: "statementName"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": name,
    color: "text",
    size: "xs",
    onClick: onVertexSelected,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "monPipelineViewer__conditional"
  }, name)));
}
function renderIfStatement({
  condition
}, onVertexSelected) {
  return [renderStatementName('if', onVertexSelected), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: "ifContent",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "s",
    paddingSize: "none",
    transparentBackground: true
  }, condition))];
}
function getStatementBody(isIf, statement, vertex, onShowVertexDetails) {
  const showVertexDetailsClicked = () => {
    onShowVertexDetails(vertex);
  };
  return isIf ? renderIfStatement(statement, showVertexDetailsClicked) : renderStatementName('else', showVertexDetailsClicked);
}
function renderNestingSpacers(depth) {
  const spacers = [];
  for (let i = 0; i < depth; i += 1) {
    spacers.push( /*#__PURE__*/_react.default.createElement("div", {
      key: `spacer_${i}`,
      className: "monPipelineViewer__spacer"
    }));
  }
  return spacers;
}
function renderStatement({
  collapse,
  element,
  element: {
    id,
    statement,
    statement: {
      vertex
    }
  },
  expand,
  isCollapsed,
  onShowVertexDetails
}) {
  if (statement instanceof _plugin_statement.PluginStatement) {
    return /*#__PURE__*/_react.default.createElement(_plugin_statement2.PluginStatement, {
      statement: statement,
      onShowVertexDetails: onShowVertexDetails
    });
  }
  const statementBody = getStatementBody(element instanceof _if_element.IfElement, statement, vertex, onShowVertexDetails);
  return /*#__PURE__*/_react.default.createElement(_collapsible_statement.CollapsibleStatement, {
    expand: expand,
    collapse: collapse,
    isCollapsed: isCollapsed,
    id: id
  }, statementBody);
}
function Statement(props) {
  const {
    depth
  } = props.element;
  return /*#__PURE__*/_react.default.createElement("li", {
    className: `monPipelineViewer__listItem`
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "monPipelineViewer__spaceContainer"
  }, renderNestingSpacers(depth)), renderStatement(props));
}
Statement.propTypes = {
  collapse: _propTypes.default.func.isRequired,
  element: _propTypes.default.shape({
    depth: _propTypes.default.number.isRequired,
    id: _propTypes.default.string.isRequired,
    statement: _propTypes.default.object.isRequired
  }).isRequired,
  expand: _propTypes.default.func.isRequired,
  isCollapsed: _propTypes.default.bool.isRequired,
  onShowVertexDetails: _propTypes.default.func.isRequired
};