"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TranslogProgress = exports.FilesProgress = exports.BytesProgress = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilesProgress = ({
  filesPercent,
  filesDone,
  filesTotal
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, filesPercent, /*#__PURE__*/_react.default.createElement("br", null), filesDone, " / ", filesTotal);
};
exports.FilesProgress = FilesProgress;
const BytesProgress = ({
  bytesPercent,
  bytesDone,
  bytesTotal
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, bytesPercent, /*#__PURE__*/_react.default.createElement("br", null), bytesDone, " / ", bytesTotal);
};
exports.BytesProgress = BytesProgress;
const TranslogProgress = ({
  hasTranslog,
  translogPercent,
  translogDone,
  translogTotal
}) => {
  return hasTranslog ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, translogPercent, /*#__PURE__*/_react.default.createElement("br", null), translogDone, " / ", translogTotal) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.shardActivity.progress.noTranslogProgressLabel",
    defaultMessage: "n/a"
  });
};
exports.TranslogProgress = TranslogProgress;