"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = Overview;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _elasticsearch_panel = require("./elasticsearch_panel");
var _kibana_panel = require("./kibana_panel");
var _logstash_panel = require("./logstash_panel");
var _beats_panel = require("./beats_panel");
var _eui = require("@elastic/eui");
var _apm_panel = require("./apm_panel");
var _enterprise_search_panel = require("./enterprise_search_panel");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Overview(props) {
  const isFromStandaloneCluster = props.cluster.cluster_uuid === _constants.STANDALONE_CLUSTER_CLUSTER_UUID;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.overview.heading",
    defaultMessage: "Stack Monitoring Overview"
  }))), !isFromStandaloneCluster ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_elasticsearch_panel.ElasticsearchPanel, (0, _extends2.default)({}, props.cluster.elasticsearch, {
    version: props.cluster.version,
    ml: props.cluster.ml,
    license: props.cluster.license,
    setupMode: props.setupMode,
    showLicenseExpiration: props.showLicenseExpiration,
    alerts: props.alerts
  })), /*#__PURE__*/_react.default.createElement(_kibana_panel.KibanaPanel, (0, _extends2.default)({}, props.cluster.kibana, {
    setupMode: props.setupMode,
    alerts: props.alerts
  }))) : null, /*#__PURE__*/_react.default.createElement(_logstash_panel.LogstashPanel, (0, _extends2.default)({}, props.cluster.logstash, {
    setupMode: props.setupMode,
    alerts: props.alerts
  })), /*#__PURE__*/_react.default.createElement(_beats_panel.BeatsPanel, (0, _extends2.default)({}, props.cluster.beats, {
    setupMode: props.setupMode,
    alerts: props.alerts
  })), /*#__PURE__*/_react.default.createElement(_apm_panel.ApmPanel, (0, _extends2.default)({}, props.cluster.apm, {
    setupMode: props.setupMode,
    alerts: props.alerts
  })), /*#__PURE__*/_react.default.createElement(_enterprise_search_panel.EnterpriseSearchPanel, (0, _extends2.default)({}, props.cluster.enterpriseSearch, {
    setupMode: props.setupMode,
    alerts: props.alerts
  }))));
}