"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogStashPipelinesPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-react-plugin/public");
var _global_state_context = require("../../contexts/global_state_context");
var _use_charts = require("../../hooks/use_charts");
var _pipelines = require("../../../lib/logstash/pipelines");
var _pipeline_listing = require("../../../components/logstash/pipeline_listing/pipeline_listing");
var _logstash_template = require("./logstash_template");
var _use_table = require("../../hooks/use_table");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogStashPipelinesPage = ({
  clusters
}) => {
  var _services$data2;
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const {
    onBrush
  } = (0, _use_charts.useCharts)();
  const {
    services
  } = (0, _public.useKibana)();
  const dateFormat = (0, _public.useUiSetting)('dateFormat');
  const clusterUuid = globalState.cluster_uuid;
  const ccs = globalState.ccs;
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  const [data, setData] = (0, _react.useState)(null);
  const {
    getPaginationTableProps,
    getPaginationRouteOptions,
    updateTotalItemCount
  } = (0, _use_table.useTable)('logstash.pipelines');
  const title = _i18n.i18n.translate('xpack.monitoring.logstash.pipelines.routeTitle', {
    defaultMessage: 'Logstash Pipelines'
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.logstash.pipelines.pageTitle', {
    defaultMessage: 'Logstash pipelines'
  });
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = `../api/monitoring/v1/clusters/${clusterUuid}/logstash/pipelines`;
    const response = await ((_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.fetch(url, {
      method: 'POST',
      body: JSON.stringify({
        ccs,
        timeRange: {
          min: bounds.min.toISOString(),
          max: bounds.max.toISOString()
        },
        ...getPaginationRouteOptions()
      })
    }));
    setData(response);
    updateTotalItemCount(response.totalPipelineCount);
  }, [ccs, clusterUuid, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http, getPaginationRouteOptions, updateTotalItemCount]);
  (0, _react.useEffect)(() => {
    if (cluster) {
      generateBreadcrumbs(cluster.cluster_name, {
        inLogstash: true
      });
    }
  }, [cluster, data, generateBreadcrumbs]);
  const renderOverview = pageData => {
    if (pageData === null) {
      return null;
    }
    const {
      clusterStatus,
      pipelines
    } = pageData || {};
    const upgradeMessage = pageData ? makeUpgradeMessage(clusterStatus.versions) : null;
    return /*#__PURE__*/_react.default.createElement(_pipeline_listing.PipelineListing, (0, _extends2.default)({
      className: "monitoringLogstashPipelinesTable",
      onBrush: xaxis => onBrush({
        xaxis
      }),
      stats: clusterStatus,
      data: pipelines
    }, getPaginationTableProps(), {
      upgradeMessage: upgradeMessage,
      dateFormat: dateFormat
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_logstash_template.LogstashTemplate, {
    title: title,
    pageTitle: pageTitle,
    getPageData: getPageData,
    cluster: cluster
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "logstashPipelinesListing"
  }, renderOverview(data)));
};
exports.LogStashPipelinesPage = LogStashPipelinesPage;
function makeUpgradeMessage(logstashVersions) {
  if (!Array.isArray(logstashVersions) || logstashVersions.length === 0 || logstashVersions.some(_pipelines.isPipelineMonitoringSupportedInVersion)) {
    return null;
  }
  return 'Pipeline monitoring is only available in Logstash version 6.0.0 or higher.';
}