"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useClusters = useClusters;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _fetch_clusters = require("../../lib/fetch_clusters");
var _use_request_error_handler = require("./use_request_error_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useClusters(clusterUuid, ccs, codePaths) {
  var _services$data;
  const {
    services
  } = (0, _public.useKibana)();
  const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
  const [min] = (0, _react.useState)(bounds.min.toISOString());
  const [max] = (0, _react.useState)(bounds.max.toISOString());
  const [clusters, setClusters] = (0, _react.useState)([]);
  const [loaded, setLoaded] = (0, _react.useState)(false);
  const handleRequestError = (0, _use_request_error_handler.useRequestErrorHandler)();
  (0, _react.useEffect)(() => {
    async function makeRequest() {
      try {
        var _services$http;
        if ((_services$http = services.http) !== null && _services$http !== void 0 && _services$http.fetch) {
          const response = await (0, _fetch_clusters.fetchClusters)({
            timeRange: {
              min,
              max
            },
            fetch: services.http.fetch,
            clusterUuid,
            codePaths
          });
          setClusters(response);
        }
      } catch (e) {
        handleRequestError(e);
      } finally {
        setLoaded(true);
      }
    }
    makeRequest();
  }, [handleRequestError, clusterUuid, ccs, services.http, codePaths, min, max]);
  return {
    clusters,
    loaded
  };
}