"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalStateProvider = exports.GlobalStateContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _url_state = require("../../url_state");
var _legacy_shims = require("../../legacy_shims");
var _should_override_refresh_interval = require("./should_override_refresh_interval");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GlobalStateContext = /*#__PURE__*/(0, _react.createContext)({});
exports.GlobalStateContext = GlobalStateContext;
const REFRESH_INTERVAL_OVERRIDE = {
  pause: false,
  value: 10000
};
const GlobalStateProvider = ({
  uiSettings,
  query,
  toasts,
  children
}) => {
  const localState = {};
  const [globalState] = (0, _react.useState)(() => new _url_state.GlobalState(query, toasts, localState));
  const initialState = globalState.getState();
  for (const key in initialState) {
    if (!initialState.hasOwnProperty(key)) {
      continue;
    }
    localState[key] = initialState[key];
  }
  localState.save = () => {
    const newState = {
      ...localState
    };
    delete newState.save;
    globalState.setState(newState);
  };

  // default to an active refresh interval if it's not conflicting with user-defined values
  if ((0, _should_override_refresh_interval.shouldOverrideRefreshInterval)(uiSettings, _legacy_shims.Legacy.shims.timefilter)) {
    localState.refreshInterval = REFRESH_INTERVAL_OVERRIDE;
    _legacy_shims.Legacy.shims.timefilter.setRefreshInterval(localState.refreshInterval);
    localState.save();
  }
  (0, _useUnmount.default)(() => {
    globalState.destroy();
  });
  return /*#__PURE__*/_react.default.createElement(GlobalStateContext.Provider, {
    value: localState
  }, children);
};
exports.GlobalStateProvider = GlobalStateProvider;