"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDerivedIndexPattern = void 0;
var _react = require("react");
var _ccs_utils = require("../../../../common/ccs_utils");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDEX_PATTERNS = `${_constants.INDEX_PATTERN_ELASTICSEARCH},${_constants.INDEX_PATTERN_KIBANA},${_constants.INDEX_PATTERN_LOGSTASH},${_constants.INDEX_PATTERN_BEATS}`;
const useDerivedIndexPattern = (dataViews, config) => {
  const indexPattern = (0, _ccs_utils.prefixIndexPatternWithCcs)(config || {}, INDEX_PATTERNS, _constants.CCS_REMOTE_PATTERN);
  const [loading, setLoading] = (0, _react.useState)(true);
  const [dataView, setDataView] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    (async function fetchData() {
      const result = await dataViews.create({
        title: indexPattern
      });
      setDataView(result);
      setLoading(false);
    })();
  }, [indexPattern, dataViews]);
  return {
    loading,
    derivedIndexPattern: dataView
  };
};
exports.useDerivedIndexPattern = useDerivedIndexPattern;