"use strict";

var _monaco_imports = require("../monaco_imports");
var _worker_proxy_service = require("./worker_proxy_service");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// This file contains a lot of single setup logic for registering a language globally

const OWNER = 'XJSON_GRAMMAR_CHECKER';
_monaco_imports.monaco.languages.onLanguage(_constants.ID, async () => {
  const wps = new _worker_proxy_service.WorkerProxyService();
  wps.setup();
  const updateAnnotations = async model => {
    if (model.isDisposed()) {
      return;
    }
    const parseResult = await wps.getAnnos(model.uri);
    if (!parseResult) {
      return;
    }
    const {
      annotations
    } = parseResult;
    _monaco_imports.monaco.editor.setModelMarkers(model, OWNER, annotations.map(({
      at,
      text,
      type
    }) => {
      const {
        column,
        lineNumber
      } = model.getPositionAt(at);
      return {
        startLineNumber: lineNumber,
        startColumn: column,
        endLineNumber: lineNumber,
        endColumn: column,
        message: text,
        severity: type === 'error' ? _monaco_imports.monaco.MarkerSeverity.Error : _monaco_imports.monaco.MarkerSeverity.Warning
      };
    }));
  };
  const onModelAdd = model => {
    if (model.getModeId() !== _constants.ID) {
      return;
    }
    const {
      dispose
    } = model.onDidChangeContent(async () => {
      updateAnnotations(model);
    });
    model.onWillDispose(() => {
      dispose();
    });
    updateAnnotations(model);
  };
  _monaco_imports.monaco.editor.onDidCreateModel(onModelAdd);
});