"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLCompletionAdapter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _dymanic_item = require("../autocomplete/dymanic_item");
var _dynamic_commands = require("../autocomplete/autocomplete_definitions/dynamic_commands");
var _autocomplete_definitions = require("../autocomplete/autocomplete_definitions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ESQLCompletionAdapter {
  constructor(worker, callbacks) {
    (0, _defineProperty2.default)(this, "triggerCharacters", ['(', ' ', '']);
    this.worker = worker;
    this.callbacks = callbacks;
  }
  async injectDynamicAutocompleteItems(suggestions, ctx) {
    const allSuggestions = await Promise.all(suggestions.map(async suggestion => {
      if (!(0, _dymanic_item.isDynamicAutocompleteItem)(suggestion)) {
        return [suggestion];
      }
      let dynamicItems = [];
      if (suggestion === _dymanic_item.DynamicAutocompleteItem.SourceIdentifier) {
        var _await$this$callbacks, _this$callbacks, _this$callbacks$getSo;
        dynamicItems = (0, _dynamic_commands.buildSourcesDefinitions)((_await$this$callbacks = await ((_this$callbacks = this.callbacks) === null || _this$callbacks === void 0 ? void 0 : (_this$callbacks$getSo = _this$callbacks.getSourceIdentifiers) === null || _this$callbacks$getSo === void 0 ? void 0 : _this$callbacks$getSo.call(_this$callbacks, ctx))) !== null && _await$this$callbacks !== void 0 ? _await$this$callbacks : []);
        if (!ctx.word && ctx.userDefinedVariables.sourceIdentifiers.length) {
          dynamicItems = [_autocomplete_definitions.pipeDefinition];
        }
      }
      if (suggestion === _dymanic_item.DynamicAutocompleteItem.FieldIdentifier) {
        var _await$this$callbacks2, _this$callbacks2, _this$callbacks2$getF;
        dynamicItems = (0, _dynamic_commands.buildFieldsDefinitions)((_await$this$callbacks2 = await ((_this$callbacks2 = this.callbacks) === null || _this$callbacks2 === void 0 ? void 0 : (_this$callbacks2$getF = _this$callbacks2.getFieldsIdentifiers) === null || _this$callbacks2$getF === void 0 ? void 0 : _this$callbacks2$getF.call(_this$callbacks2, ctx))) !== null && _await$this$callbacks2 !== void 0 ? _await$this$callbacks2 : []);
      }
      if (suggestion === _dymanic_item.DynamicAutocompleteItem.PolicyIdentifier) {
        var _this$callbacks3, _this$callbacks3$getP;
        const results = await ((_this$callbacks3 = this.callbacks) === null || _this$callbacks3 === void 0 ? void 0 : (_this$callbacks3$getP = _this$callbacks3.getPoliciesIdentifiers) === null || _this$callbacks3$getP === void 0 ? void 0 : _this$callbacks3$getP.call(_this$callbacks3, ctx));
        dynamicItems = results !== null && results !== void 0 && results.length ? (0, _dynamic_commands.buildPoliciesDefinitions)(results) : (0, _dynamic_commands.buildNoPoliciesAvailableDefinition)();
      }
      if (suggestion === _dymanic_item.DynamicAutocompleteItem.PolicyFieldIdentifier) {
        var _this$callbacks4, _this$callbacks4$getP;
        dynamicItems = (0, _dynamic_commands.buildFieldsDefinitions)((await ((_this$callbacks4 = this.callbacks) === null || _this$callbacks4 === void 0 ? void 0 : (_this$callbacks4$getP = _this$callbacks4.getPolicyFieldsIdentifiers) === null || _this$callbacks4$getP === void 0 ? void 0 : _this$callbacks4$getP.call(_this$callbacks4, ctx))) || []);
      }
      if (suggestion === _dymanic_item.DynamicAutocompleteItem.PolicyMatchingFieldIdentifier) {
        var _this$callbacks5, _this$callbacks5$getF, _this$callbacks6, _this$callbacks6$getP;
        const [fields = [], matchingField] = await Promise.all([(_this$callbacks5 = this.callbacks) === null || _this$callbacks5 === void 0 ? void 0 : (_this$callbacks5$getF = _this$callbacks5.getFieldsIdentifiers) === null || _this$callbacks5$getF === void 0 ? void 0 : _this$callbacks5$getF.call(_this$callbacks5, ctx), (_this$callbacks6 = this.callbacks) === null || _this$callbacks6 === void 0 ? void 0 : (_this$callbacks6$getP = _this$callbacks6.getPolicyMatchingFieldIdentifiers) === null || _this$callbacks6$getP === void 0 ? void 0 : _this$callbacks6$getP.call(_this$callbacks6, ctx)]);
        dynamicItems = matchingField !== null && matchingField !== void 0 && matchingField.length ? (0, _dynamic_commands.buildMatchingFieldsDefinition)(matchingField[0], fields) : (0, _dynamic_commands.buildFieldsDefinitions)(fields);
      }
      return dynamicItems;
    }));
    return allSuggestions.flat();
  }
  async provideCompletionItems(model, position) {
    const lines = model.getLineCount();
    const currentLineChars = model.getValueInRange({
      startLineNumber: 0,
      startColumn: 0,
      endLineNumber: position.lineNumber,
      endColumn: position.column
    });
    const wordInfo = model.getWordUntilPosition(position);
    const worker = await this.worker(model.uri);
    const providedSuggestions = lines !== position.lineNumber || model.getLineContent(position.lineNumber).trimEnd().length >= position.column ? await worker.provideAutocompleteSuggestionsFromString(currentLineChars) : await worker.provideAutocompleteSuggestions(model.uri.toString(), {
      word: wordInfo.word,
      line: position.lineNumber,
      index: position.column
    });
    const withDynamicItems = providedSuggestions ? await this.injectDynamicAutocompleteItems(providedSuggestions.suggestions, {
      word: wordInfo.word,
      userDefinedVariables: providedSuggestions.userDefinedVariables
    }) : [];
    return {
      suggestions: withDynamicItems.map(i => ({
        ...i,
        range: {
          startLineNumber: position.lineNumber,
          endLineNumber: position.lineNumber,
          startColumn: wordInfo.startColumn,
          endColumn: wordInfo.endColumn
        }
      }))
    };
  }
}
exports.ESQLCompletionAdapter = ESQLCompletionAdapter;