"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.THRESHOLD_MET_GROUP = exports.ANOMALY_SCORE_MATCH_GROUP_ID = exports.ANOMALY_DETECTION_AAD_INDEX_NAME = exports.ANOMALY_DETECTION_AAD_CONFIG = void 0;
exports.registerAnomalyDetectionAlertType = registerAnomalyDetectionAlertType;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _fieldTypes = require("@kbn/field-types");
var _alerts = require("../../../common/constants/alerts");
var _app = require("../../../common/constants/app");
var _license = require("../../../common/license");
var _alerting_schema = require("../../routes/schemas/alerting_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Base Anomaly detection alerting rule context.
 * Relevant for both active and recovered alerts.
 */

// Flattened alert payload for alert-as-data

const ANOMALY_SCORE_MATCH_GROUP_ID = 'anomaly_score_match';
exports.ANOMALY_SCORE_MATCH_GROUP_ID = ANOMALY_SCORE_MATCH_GROUP_ID;
const ANOMALY_DETECTION_AAD_INDEX_NAME = 'ml.anomaly-detection';
exports.ANOMALY_DETECTION_AAD_INDEX_NAME = ANOMALY_DETECTION_AAD_INDEX_NAME;
const ANOMALY_DETECTION_AAD_CONFIG = {
  context: ANOMALY_DETECTION_AAD_INDEX_NAME,
  mappings: {
    fieldMap: {
      [_alerts.ALERT_ANOMALY_DETECTION_JOB_ID]: {
        type: _fieldTypes.ES_FIELD_TYPES.KEYWORD,
        array: false,
        required: true
      },
      [_alerts.ALERT_ANOMALY_SCORE]: {
        type: _fieldTypes.ES_FIELD_TYPES.DOUBLE,
        array: false,
        required: false
      },
      [_alerts.ALERT_ANOMALY_IS_INTERIM]: {
        type: _fieldTypes.ES_FIELD_TYPES.BOOLEAN,
        array: false,
        required: false
      },
      [_alerts.ALERT_ANOMALY_TIMESTAMP]: {
        type: _fieldTypes.ES_FIELD_TYPES.DATE,
        array: false,
        required: false
      },
      [_alerts.ALERT_TOP_RECORDS]: {
        type: _fieldTypes.ES_FIELD_TYPES.OBJECT,
        array: true,
        required: false,
        dynamic: false,
        properties: {
          job_id: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          record_score: {
            type: _fieldTypes.ES_FIELD_TYPES.DOUBLE
          },
          initial_record_score: {
            type: _fieldTypes.ES_FIELD_TYPES.DOUBLE
          },
          detector_index: {
            type: _fieldTypes.ES_FIELD_TYPES.INTEGER
          },
          is_interim: {
            type: _fieldTypes.ES_FIELD_TYPES.BOOLEAN
          },
          timestamp: {
            type: _fieldTypes.ES_FIELD_TYPES.DATE
          },
          partition_field_name: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          partition_field_value: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          over_field_name: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          over_field_value: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          by_field_name: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          by_field_value: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          function: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          typical: {
            type: _fieldTypes.ES_FIELD_TYPES.DOUBLE
          },
          actual: {
            type: _fieldTypes.ES_FIELD_TYPES.DOUBLE
          },
          field_name: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          }
        }
      },
      [_alerts.ALERT_TOP_INFLUENCERS]: {
        type: _fieldTypes.ES_FIELD_TYPES.OBJECT,
        array: true,
        required: false,
        dynamic: false,
        properties: {
          job_id: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          influencer_field_name: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          influencer_field_value: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          influencer_score: {
            type: _fieldTypes.ES_FIELD_TYPES.DOUBLE
          },
          initial_influencer_score: {
            type: _fieldTypes.ES_FIELD_TYPES.DOUBLE
          },
          is_interim: {
            type: _fieldTypes.ES_FIELD_TYPES.BOOLEAN
          },
          timestamp: {
            type: _fieldTypes.ES_FIELD_TYPES.DATE
          }
        }
      }
    }
  },
  shouldWrite: true
};
exports.ANOMALY_DETECTION_AAD_CONFIG = ANOMALY_DETECTION_AAD_CONFIG;
const THRESHOLD_MET_GROUP = {
  id: ANOMALY_SCORE_MATCH_GROUP_ID,
  name: _i18n.i18n.translate('xpack.ml.anomalyDetectionAlert.actionGroupName', {
    defaultMessage: 'Anomaly score matched the condition'
  })
};
exports.THRESHOLD_MET_GROUP = THRESHOLD_MET_GROUP;
function registerAnomalyDetectionAlertType({
  alerting,
  mlSharedServices
}) {
  alerting.registerType({
    id: _alerts.ML_ALERT_TYPES.ANOMALY_DETECTION,
    name: _i18n.i18n.translate('xpack.ml.anomalyDetectionAlert.name', {
      defaultMessage: 'Anomaly detection'
    }),
    actionGroups: [THRESHOLD_MET_GROUP],
    defaultActionGroupId: ANOMALY_SCORE_MATCH_GROUP_ID,
    validate: {
      params: _alerting_schema.mlAnomalyDetectionAlertParams
    },
    actionVariables: {
      context: [{
        name: 'timestamp',
        description: _i18n.i18n.translate('xpack.ml.alertContext.timestampDescription', {
          defaultMessage: 'The bucket timestamp of the anomaly'
        })
      }, {
        name: 'timestampIso8601',
        description: _i18n.i18n.translate('xpack.ml.alertContext.timestampIso8601Description', {
          defaultMessage: 'The bucket time of the anomaly in ISO8601 format'
        })
      }, {
        name: 'jobIds',
        description: _i18n.i18n.translate('xpack.ml.alertContext.jobIdsDescription', {
          defaultMessage: 'List of job IDs that triggered the alert'
        })
      }, {
        name: 'message',
        description: _i18n.i18n.translate('xpack.ml.alertContext.messageDescription', {
          defaultMessage: 'Alert info message'
        })
      }, {
        name: 'isInterim',
        description: _i18n.i18n.translate('xpack.ml.alertContext.isInterimDescription', {
          defaultMessage: 'Indicate if top hits contain interim results'
        })
      }, {
        name: 'score',
        description: _i18n.i18n.translate('xpack.ml.alertContext.scoreDescription', {
          defaultMessage: 'Anomaly score at the time of the notification action'
        })
      }, {
        name: 'topRecords',
        description: _i18n.i18n.translate('xpack.ml.alertContext.topRecordsDescription', {
          defaultMessage: 'Top records'
        })
      }, {
        name: 'topInfluencers',
        description: _i18n.i18n.translate('xpack.ml.alertContext.topInfluencersDescription', {
          defaultMessage: 'Top influencers'
        })
      }, {
        name: 'anomalyExplorerUrl',
        description: _i18n.i18n.translate('xpack.ml.alertContext.anomalyExplorerUrlDescription', {
          defaultMessage: 'URL to open in the Anomaly Explorer'
        }),
        useWithTripleBracesInTemplates: true
      }]
    },
    category: _server.DEFAULT_APP_CATEGORIES.management.id,
    producer: _app.PLUGIN_ID,
    minimumLicenseRequired: _license.MINIMUM_FULL_LICENSE,
    isExportable: true,
    doesSetRecoveryContext: true,
    executor: async ({
      services,
      params,
      spaceId
    }) => {
      const fakeRequest = {};
      const {
        execute
      } = mlSharedServices.alertingServiceProvider(services.savedObjectsClient, fakeRequest);
      const {
        alertsClient
      } = services;
      if (!alertsClient) return {
        state: {}
      };
      const executionResult = await execute(params, spaceId);
      if (!executionResult) return {
        state: {}
      };
      const {
        isHealthy,
        name,
        context,
        payload
      } = executionResult;
      if (!isHealthy) {
        alertsClient.report({
          id: name,
          actionGroup: ANOMALY_SCORE_MATCH_GROUP_ID,
          context,
          payload: {
            [_ruleDataUtils.ALERT_URL]: payload[_ruleDataUtils.ALERT_URL],
            [_ruleDataUtils.ALERT_REASON]: payload[_ruleDataUtils.ALERT_REASON],
            [_alerts.ALERT_ANOMALY_DETECTION_JOB_ID]: payload.job_id,
            [_alerts.ALERT_ANOMALY_SCORE]: payload.anomaly_score,
            [_alerts.ALERT_ANOMALY_IS_INTERIM]: payload.is_interim,
            [_alerts.ALERT_ANOMALY_TIMESTAMP]: payload.anomaly_timestamp,
            [_alerts.ALERT_TOP_RECORDS]: payload.top_records,
            [_alerts.ALERT_TOP_INFLUENCERS]: payload.top_influencers
          }
        });
      }

      // Set context for recovered alerts
      for (const recoveredAlert of alertsClient.getRecoveredAlerts()) {
        if (isHealthy) {
          const alertId = recoveredAlert.alert.getId();
          alertsClient.setAlertData({
            id: alertId,
            context,
            payload: {
              [_ruleDataUtils.ALERT_URL]: payload[_ruleDataUtils.ALERT_URL],
              [_ruleDataUtils.ALERT_REASON]: payload[_ruleDataUtils.ALERT_REASON],
              [_alerts.ALERT_ANOMALY_DETECTION_JOB_ID]: payload.job_id
            }
          });
        }
      }
      return {
        state: {}
      };
    },
    alerts: ANOMALY_DETECTION_AAD_CONFIG
  });
}