"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OPEN_IN_ANOMALY_EXPLORER_ACTION = void 0;
exports.createOpenInExplorerAction = createOpenInExplorerAction;
var _i18n = require("@kbn/i18n");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _locator = require("../../common/constants/locator");
var _embeddables = require("../embeddables");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_IN_ANOMALY_EXPLORER_ACTION = 'openInAnomalyExplorerAction';
exports.OPEN_IN_ANOMALY_EXPLORER_ACTION = OPEN_IN_ANOMALY_EXPLORER_ACTION;
function createOpenInExplorerAction(getStartServices) {
  return {
    id: 'open-in-anomaly-explorer',
    type: OPEN_IN_ANOMALY_EXPLORER_ACTION,
    getIconType(context) {
      return 'visTable';
    },
    getDisplayName() {
      return _i18n.i18n.translate('xpack.ml.actions.openInAnomalyExplorerTitle', {
        defaultMessage: 'Open in Anomaly Explorer'
      });
    },
    async getHref(context) {
      const [, pluginsStart] = await getStartServices();
      const locator = pluginsStart.share.url.locators.get(_locator.ML_APP_LOCATOR);
      if ((0, _embeddables.isSwimLaneEmbeddable)(context)) {
        const {
          embeddable,
          data
        } = context;
        const {
          jobIds,
          timeRange,
          viewBy
        } = embeddable.getInput();
        const {
          perPage,
          fromPage
        } = embeddable.getOutput();
        return locator.getUrl({
          page: 'explorer',
          pageState: {
            jobIds,
            timeRange,
            mlExplorerSwimlane: {
              viewByFromPage: fromPage,
              viewByPerPage: perPage,
              viewByFieldName: viewBy,
              ...(data ? {
                selectedType: data.type,
                selectedTimes: data.times,
                selectedLanes: data.lanes
              } : {})
            }
          }
        });
      } else if ((0, _embeddables.isAnomalyExplorerEmbeddable)(context)) {
        const {
          embeddable
        } = context;
        const {
          jobIds,
          timeRange
        } = embeddable.getInput();
        const {
          entityFields
        } = embeddable.getOutput();
        let mlExplorerFilter;
        if (Array.isArray(entityFields) && entityFields.length === 1 && entityFields[0].operation === _mlAnomalyUtils.ML_ENTITY_FIELD_OPERATIONS.ADD) {
          const {
            fieldName,
            fieldValue
          } = entityFields[0];
          if (fieldName !== undefined && fieldValue !== undefined) {
            const influencersFilterQuery = {
              bool: {
                should: [{
                  match_phrase: {
                    [fieldName]: String(fieldValue)
                  }
                }],
                minimum_should_match: 1
              }
            };
            const filteredFields = [fieldName, fieldValue];
            mlExplorerFilter = {
              influencersFilterQuery,
              filterActive: true,
              queryString: `${fieldName}:"${fieldValue}"`,
              ...(Array.isArray(filteredFields) ? {
                filteredFields
              } : {})
            };
          }
        }
        return locator.getUrl({
          page: 'explorer',
          pageState: {
            jobIds,
            timeRange,
            // @ts-ignore QueryDslQueryContainer is not compatible with SerializableRecord
            ...(mlExplorerFilter ? {
              mlExplorerFilter
            } : {}),
            query: {}
          }
        });
      }
    },
    async execute(context) {
      if (!context.embeddable) {
        throw new Error('Not possible to execute an action without the embeddable context');
      }
      const [{
        application
      }] = await getStartServices();
      const anomalyExplorerUrl = await this.getHref(context);
      if (anomalyExplorerUrl) {
        await application.navigateToUrl(anomalyExplorerUrl);
      }
    },
    async isCompatible({
      embeddable
    }) {
      return embeddable.type === _embeddables.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE || embeddable.type === _embeddables.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE;
    }
  };
}