"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeepLinks = getDeepLinks;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _locator = require("../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createDeepLinks(mlCapabilities, isFullLicense, showMLNavMenu) {
  function getNavStatus(visible, showInServerless = true) {
    if (showMLNavMenu === false) {
      // in serverless the status needs to be "visible" rather than "default"
      // for the links to appear in the nav menu.
      return showInServerless && visible ? _public.AppNavLinkStatus.visible : _public.AppNavLinkStatus.hidden;
    }
    return visible ? _public.AppNavLinkStatus.default : _public.AppNavLinkStatus.hidden;
  }
  return {
    getOverviewLinkDeepLink: () => {
      const navLinkStatus = getNavStatus(mlCapabilities.isADEnabled || mlCapabilities.isDFAEnabled);
      return {
        id: 'overview',
        title: _i18n.i18n.translate('xpack.ml.deepLink.overview', {
          defaultMessage: 'Overview'
        }),
        path: `/${_locator.ML_PAGES.OVERVIEW}`,
        navLinkStatus
      };
    },
    getAnomalyDetectionDeepLink: () => {
      const navLinkStatus = getNavStatus(mlCapabilities.isADEnabled);
      return {
        id: 'anomalyDetection',
        title: _i18n.i18n.translate('xpack.ml.deepLink.anomalyDetection', {
          defaultMessage: 'Anomaly Detection'
        }),
        path: `/${_locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE}`,
        navLinkStatus,
        deepLinks: [{
          id: 'anomalyExplorer',
          title: _i18n.i18n.translate('xpack.ml.deepLink.anomalyExplorer', {
            defaultMessage: 'Anomaly explorer'
          }),
          path: `/${_locator.ML_PAGES.ANOMALY_EXPLORER}`,
          navLinkStatus
        }, {
          id: 'singleMetricViewer',
          title: _i18n.i18n.translate('xpack.ml.deepLink.singleMetricViewer', {
            defaultMessage: 'Single metric viewer'
          }),
          path: `/${_locator.ML_PAGES.SINGLE_METRIC_VIEWER}`,
          navLinkStatus
        }]
      };
    },
    getDataFrameAnalyticsDeepLink: () => {
      const navLinkStatus = getNavStatus(mlCapabilities.isDFAEnabled);
      return {
        id: 'dataFrameAnalytics',
        title: _i18n.i18n.translate('xpack.ml.deepLink.dataFrameAnalytics', {
          defaultMessage: 'Data Frame Analytics'
        }),
        path: `/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE}`,
        navLinkStatus,
        deepLinks: [{
          id: 'resultExplorer',
          title: _i18n.i18n.translate('xpack.ml.deepLink.resultExplorer', {
            defaultMessage: 'Results explorer'
          }),
          path: `/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION}`,
          navLinkStatus
        }, {
          id: 'analyticsMap',
          title: _i18n.i18n.translate('xpack.ml.deepLink.analyticsMap', {
            defaultMessage: 'Analytics map'
          }),
          path: `/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_MAP}`,
          navLinkStatus
        }]
      };
    },
    getModelManagementDeepLink: () => {
      const navLinkStatus = getNavStatus(mlCapabilities.isDFAEnabled || mlCapabilities.isNLPEnabled);
      return {
        id: 'modelManagement',
        title: _i18n.i18n.translate('xpack.ml.deepLink.modelManagement', {
          defaultMessage: 'Model Management'
        }),
        path: `/${_locator.ML_PAGES.TRAINED_MODELS_MANAGE}`,
        navLinkStatus,
        deepLinks: [{
          id: 'nodesOverview',
          title: _i18n.i18n.translate('xpack.ml.deepLink.trainedModels', {
            defaultMessage: 'Trained Models'
          }),
          path: `/${_locator.ML_PAGES.TRAINED_MODELS_MANAGE}`,
          navLinkStatus
        }, {
          id: 'nodes',
          title: _i18n.i18n.translate('xpack.ml.deepLink.nodes', {
            defaultMessage: 'Nodes'
          }),
          path: `/${_locator.ML_PAGES.NODES}`,
          navLinkStatus: getNavStatus(mlCapabilities.isDFAEnabled || mlCapabilities.isNLPEnabled, false)
        }]
      };
    },
    getMemoryUsageDeepLink: () => {
      return {
        id: 'memoryUsage',
        title: _i18n.i18n.translate('xpack.ml.deepLink.memoryUsage', {
          defaultMessage: 'Memory Usage'
        }),
        path: `/${_locator.ML_PAGES.MEMORY_USAGE}`,
        navLinkStatus: getNavStatus(isFullLicense, true)
      };
    },
    getSettingsDeepLink: () => {
      const navLinkStatus = getNavStatus(mlCapabilities.isADEnabled);
      return {
        id: 'settings',
        title: _i18n.i18n.translate('xpack.ml.deepLink.settings', {
          defaultMessage: 'Settings'
        }),
        path: `/${_locator.ML_PAGES.SETTINGS}`,
        navLinkStatus,
        deepLinks: [{
          id: 'calendarSettings',
          title: _i18n.i18n.translate('xpack.ml.deepLink.calendarSettings', {
            defaultMessage: 'Calendars'
          }),
          path: `/${_locator.ML_PAGES.CALENDARS_MANAGE}`,
          navLinkStatus
        }, {
          id: 'filterListsSettings',
          title: _i18n.i18n.translate('xpack.ml.deepLink.filterListsSettings', {
            defaultMessage: 'Filter Lists'
          }),
          path: `/${_locator.ML_PAGES.SETTINGS}`,
          // Link to settings page as read only users cannot view filter lists.
          navLinkStatus
        }]
      };
    },
    getAiopsDeepLink: () => {
      const navLinkStatus = getNavStatus(mlCapabilities.canUseAiops);
      return {
        id: 'aiOps',
        title: _i18n.i18n.translate('xpack.ml.deepLink.aiOps', {
          defaultMessage: 'AIOps'
        }),
        // Default to the index select page for log rate analysis since we don't have an AIops overview page
        path: `/${_locator.ML_PAGES.AIOPS_LOG_RATE_ANALYSIS_INDEX_SELECT}`,
        navLinkStatus,
        deepLinks: [{
          id: 'logRateAnalysis',
          title: _i18n.i18n.translate('xpack.ml.deepLink.logRateAnalysis', {
            defaultMessage: 'Log Rate Analysis'
          }),
          path: `/${_locator.ML_PAGES.AIOPS_LOG_RATE_ANALYSIS_INDEX_SELECT}`,
          navLinkStatus
        }, {
          id: 'logPatternAnalysis',
          title: _i18n.i18n.translate('xpack.ml.deepLink.logPatternAnalysis', {
            defaultMessage: 'Log Pattern Analysis'
          }),
          path: `/${_locator.ML_PAGES.AIOPS_LOG_CATEGORIZATION_INDEX_SELECT}`,
          navLinkStatus
        }, {
          id: 'changePointDetections',
          title: _i18n.i18n.translate('xpack.ml.deepLink.changePointDetection', {
            defaultMessage: 'Change Point Detection'
          }),
          path: `/${_locator.ML_PAGES.AIOPS_CHANGE_POINT_DETECTION_INDEX_SELECT}`,
          navLinkStatus
        }]
      };
    },
    getNotificationsDeepLink: () => {
      return {
        id: 'notifications',
        title: _i18n.i18n.translate('xpack.ml.deepLink.notifications', {
          defaultMessage: 'Notifications'
        }),
        path: `/${_locator.ML_PAGES.NOTIFICATIONS}`,
        navLinkStatus: getNavStatus(isFullLicense)
      };
    },
    getDataVisualizerDeepLink: () => {
      return {
        id: 'dataVisualizer',
        title: _i18n.i18n.translate('xpack.ml.deepLink.dataVisualizer', {
          defaultMessage: 'Data Visualizer'
        }),
        path: `/${_locator.ML_PAGES.DATA_VISUALIZER}`,
        navLinkStatus: getNavStatus(true)
      };
    },
    getFileUploadDeepLink: () => {
      return {
        id: 'fileUpload',
        title: _i18n.i18n.translate('xpack.ml.deepLink.fileUpload', {
          defaultMessage: 'File Upload'
        }),
        keywords: ['CSV', 'JSON'],
        path: `/${_locator.ML_PAGES.DATA_VISUALIZER_FILE}`,
        navLinkStatus: getNavStatus(true)
      };
    },
    getIndexDataVisualizerDeepLink: () => {
      return {
        id: 'indexDataVisualizer',
        title: _i18n.i18n.translate('xpack.ml.deepLink.indexDataVisualizer', {
          defaultMessage: 'Index Data Visualizer'
        }),
        path: `/${_locator.ML_PAGES.DATA_VISUALIZER_INDEX_SELECT}`,
        navLinkStatus: getNavStatus(true)
      };
    },
    getDataDriftDeepLink: () => {
      return {
        id: 'dataDrift',
        title: _i18n.i18n.translate('xpack.ml.deepLink.dataDrift', {
          defaultMessage: 'Data Drift'
        }),
        path: `/${_locator.ML_PAGES.DATA_DRIFT_INDEX_SELECT}`,
        navLinkStatus: getNavStatus(true)
      };
    }
  };
}
function getDeepLinks(isFullLicense, mlCapabilities, showMLNavMenu) {
  const links = createDeepLinks(mlCapabilities, isFullLicense, showMLNavMenu);
  return Object.values(links).map(link => link());
}