"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatEditCalendarUrl = formatEditCalendarUrl;
exports.formatEditFilterUrl = formatEditFilterUrl;
var _public = require("@kbn/kibana-utils-plugin/public");
var _locator = require("../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatEditCalendarUrl(appBasePath, pageState) {
  let url = `${appBasePath}/${_locator.ML_PAGES.CALENDARS_EDIT}`;
  if (pageState) {
    const {
      globalState,
      calendarId
    } = pageState;
    if (calendarId !== undefined) {
      url = `${url}/${calendarId}`;
    }
    if (globalState) {
      url = (0, _public.setStateToKbnUrl)('_g', globalState, {
        useHash: false,
        storeInHashQuery: false
      }, url);
    }
  }
  return url;
}
function formatEditFilterUrl(appBasePath, pageState) {
  let url = `${appBasePath}/${_locator.ML_PAGES.FILTER_LISTS_EDIT}`;
  if (pageState) {
    const {
      globalState,
      filterId
    } = pageState;
    if (filterId !== undefined) {
      url = `${url}/${filterId}`;
    }
    if (globalState) {
      url = (0, _public.setStateToKbnUrl)('_g', globalState, {
        useHash: false,
        storeInHashQuery: false
      }, url);
    }
  }
  return url;
}