"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFlyout = createFlyout;
var _react = _interopRequireDefault(require("react"));
var _operators = require("rxjs/operators");
var _rxjs = require("rxjs");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _app = require("../../../application/app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createFlyout(FlyoutComponent, coreStart, share, data, dashboardService, lens) {
  const {
    http,
    theme,
    i18n,
    overlays,
    application: {
      currentAppId$
    }
  } = coreStart;
  return new Promise(async (resolve, reject) => {
    try {
      const onFlyoutClose = () => {
        flyoutSession.close();
        resolve();
      };
      const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
        services: {
          ...coreStart,
          share,
          data,
          lens,
          dashboardService,
          mlServices: (0, _app.getMlGlobalServices)(http)
        }
      }, /*#__PURE__*/_react.default.createElement(FlyoutComponent, {
        onClose: () => {
          onFlyoutClose();
          resolve();
        }
      })), {
        theme,
        i18n
      }), {
        'data-test-subj': 'mlFlyoutLayerSelector',
        ownFocus: true,
        onClose: onFlyoutClose,
        size: '35vw'
      });

      // Close the flyout when user navigates out of the current plugin
      currentAppId$.pipe((0, _operators.skip)(1), (0, _operators.takeUntil)((0, _rxjs.from)(flyoutSession.onClose)), (0, _operators.distinctUntilChanged)()).subscribe(() => {
        flyoutSession.close();
      });
    } catch (error) {
      reject(error);
    }
  });
}