"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateJob = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _utils = require("../../../../application/jobs/new_job/job_from_pattern_analysis/utils");
var _general = require("../../../../application/jobs/new_job/common/job_creator/util/general");
var _new_job_capabilities_service = require("../../../../application/services/new_job_capabilities/new_job_capabilities_service");
var _job_from_pattern_analysis = require("../../../../application/jobs/new_job/job_from_pattern_analysis");
var _context = require("../../common/context");
var _job_details = require("../../common/job_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateJob = ({
  dataView,
  field,
  query,
  timeRange
}) => {
  const {
    services: {
      data,
      share,
      uiSettings,
      mlServices: {
        mlApiServices
      },
      dashboardService
    }
  } = (0, _context.useMlFromLensKibanaContext)();
  const [categorizationType, setCategorizationType] = (0, _react.useState)(_job_from_pattern_analysis.CATEGORIZATION_TYPE.COUNT);
  const [enablePerPartitionCategorization, setEnablePerPartitionCategorization] = (0, _react.useState)(false);
  const [stopOnWarn, setStopOnWarn] = (0, _react.useState)(false);
  const [categoryFieldOptions, setCategoryFieldsOptions] = (0, _react.useState)([]);
  const [selectedPartitionFieldOptions, setSelectedPartitionFieldOptions] = (0, _react.useState)([]);
  const [formComplete, setFormComplete] = (0, _react.useState)(undefined);
  const toggleEnablePerPartitionCategorization = (0, _react.useCallback)(() => setEnablePerPartitionCategorization(!enablePerPartitionCategorization), [enablePerPartitionCategorization]);
  const toggleStopOnWarn = (0, _react.useCallback)(() => setStopOnWarn(!stopOnWarn), [stopOnWarn]);
  (0, _react.useMemo)(() => {
    const newJobCapsService = new _new_job_capabilities_service.NewJobCapsService(mlApiServices);
    newJobCapsService.initializeFromDataVIew(dataView).then(() => {
      const options = [...(0, _general.createFieldOptions)(newJobCapsService.categoryFields, [])].map(o => ({
        ...o
      }));
      setCategoryFieldsOptions(options);
    });
  }, [dataView, mlApiServices]);
  const quickJobCreator = (0, _react.useMemo)(() => new _job_from_pattern_analysis.QuickCategorizationJobCreator(uiSettings, data.query.timefilter.timefilter, dashboardService, data, mlApiServices), [dashboardService, data, mlApiServices, uiSettings]);
  function createADJobInWizard() {
    var _dataView$getFieldByN;
    const partitionField = selectedPartitionFieldOptions.length ? (_dataView$getFieldByN = dataView.getFieldByName(selectedPartitionFieldOptions[0].label)) !== null && _dataView$getFieldByN !== void 0 ? _dataView$getFieldByN : null : null;
    (0, _utils.redirectToADJobWizards)(categorizationType, dataView, field, partitionField, stopOnWarn, query, timeRange, share);
  }
  (0, _react.useEffect)(() => {
    setSelectedPartitionFieldOptions([]);
    setStopOnWarn(false);
  }, [enablePerPartitionCategorization]);
  (0, _react.useEffect)(() => {
    setFormComplete(enablePerPartitionCategorization === false || selectedPartitionFieldOptions.length > 0);
  }, [enablePerPartitionCategorization, selectedPartitionFieldOptions]);
  async function createADJob({
    jobId,
    bucketSpan,
    startJob,
    runInRealTime
  }) {
    var _dataView$getFieldByN2;
    const partitionField = selectedPartitionFieldOptions.length ? (_dataView$getFieldByN2 = dataView.getFieldByName(selectedPartitionFieldOptions[0].label)) !== null && _dataView$getFieldByN2 !== void 0 ? _dataView$getFieldByN2 : null : null;
    const result = await quickJobCreator.createAndSaveJob(categorizationType, jobId, bucketSpan, dataView, field, partitionField, stopOnWarn, query, timeRange, startJob, runInRealTime);
    return result;
  }
  return /*#__PURE__*/_react.default.createElement(_job_details.JobDetails, {
    createADJob: createADJob,
    createADJobInWizard: createADJobInWizard,
    embeddable: undefined,
    timeRange: timeRange,
    layer: undefined,
    layerIndex: 0,
    outerFormComplete: formComplete
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: 'count',
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Count",
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.count.title"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Look for anomalies in the event rate of a category.",
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.count.description"
    })),
    checked: categorizationType === _job_from_pattern_analysis.CATEGORIZATION_TYPE.COUNT,
    onChange: () => setCategorizationType(_job_from_pattern_analysis.CATEGORIZATION_TYPE.COUNT)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: 'rare',
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Rare",
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.rare.title"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Look for categories that occur rarely in time.",
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.rare.description"
    })),
    checked: categorizationType === _job_from_pattern_analysis.CATEGORIZATION_TYPE.RARE,
    onChange: () => setCategorizationType(_job_from_pattern_analysis.CATEGORIZATION_TYPE.RARE)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "categorizationPerPartitionSwitch",
    disabled: false,
    checked: enablePerPartitionCategorization,
    onChange: toggleEnablePerPartitionCategorization,
    "data-test-subj": "mlNewJobFromPatternAnalysisFlyoutSwitchCategorizationPerPartition",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.perPartitionCategorizationSwitchLabel",
      defaultMessage: "Enable per-partition categorization"
    })
  }), enablePerPartitionCategorization ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.categorizationPerPartitionField.infoCallout",
      defaultMessage: "Determine categories independently for each value of the partition field."
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.categorizationPerPartitionFieldLabel",
      defaultMessage: "Partition field"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: {
      asPlainText: true
    },
    options: categoryFieldOptions,
    selectedOptions: selectedPartitionFieldOptions,
    onChange: setSelectedPartitionFieldOptions,
    isClearable: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "categorizationPerPartitionSwitch",
    disabled: false,
    checked: stopOnWarn,
    onChange: toggleStopOnWarn,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJobFromPatternAnalysisFlyout.stopOnWarnSwitchLabel",
      defaultMessage: "Stop on warn"
    })
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  })));
};
exports.CreateJob = CreateJob;