"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  registerEmbeddables: true,
  getEmbeddableComponent: true
};
Object.defineProperty(exports, "getEmbeddableComponent", {
  enumerable: true,
  get: function () {
    return _get_embeddable_component.getEmbeddableComponent;
  }
});
exports.registerEmbeddables = registerEmbeddables;
var _anomaly_swimlane = require("./anomaly_swimlane");
var _anomaly_charts = require("./anomaly_charts");
var _constants = require("./constants");
Object.keys(_constants).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _constants[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _constants[key];
    }
  });
});
var _types = require("./types");
Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _types[key];
    }
  });
});
var _get_embeddable_component = require("./get_embeddable_component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerEmbeddables(embeddable, core) {
  const anomalySwimlaneEmbeddableFactory = new _anomaly_swimlane.AnomalySwimlaneEmbeddableFactory(core.getStartServices);
  embeddable.registerEmbeddableFactory(anomalySwimlaneEmbeddableFactory.type, anomalySwimlaneEmbeddableFactory);
  const anomalyChartsFactory = new _anomaly_charts.AnomalyChartsEmbeddableFactory(core.getStartServices);
  embeddable.registerEmbeddableFactory(anomalyChartsFactory.type, anomalyChartsFactory);
}