"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSeriesExplorerPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _anomaly_results_view_selector = require("../components/anomaly_results_view_selector");
var _job_selector = require("../components/job_selector");
var _help_menu = require("../components/help_menu");
var _kibana = require("../contexts/kibana");
var _page_header = require("../components/page_header");
var _page_title = require("../components/page_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimeSeriesExplorerPage = ({
  children,
  dateFormatTz,
  resizeRef,
  noSingleMetricJobsFound
}) => {
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const helpLink = docLinks.links.ml.anomalyDetection;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "ml-time-series-explorer",
    ref: resizeRef,
    "data-test-subj": "mlPageSingleMetricViewer"
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_anomaly_results_view_selector.AnomalyResultsViewSelector, {
    viewId: "timeseriesexplorer"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.pageTitle', {
      defaultMessage: 'Single Metric Viewer'
    })
  })))), noSingleMetricJobsFound ? null : /*#__PURE__*/_react.default.createElement(_job_selector.JobSelector, {
    dateFormatTz: dateFormatTz,
    singleSelection: true,
    timeseriesOnly: true
  }), children, /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink
  })));
};
exports.TimeSeriesExplorerPage = TimeSeriesExplorerPage;