"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditFilterListHeader = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _edit_description_popover = require("../components/edit_description_popover");
var _filter_list_usage_popover = require("../components/filter_list_usage_popover");
var _page_header = require("../../../components/page_header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for the header section of the edit filter list page, showing the
 * filter ID, description, number of items, and the jobs and detectors using the filter list.
 */

const EditFilterListHeader = ({
  canCreateFilter,
  filterId,
  totalItemCount,
  description,
  updateDescription,
  newFilterId,
  isNewFilterIdInvalid,
  updateNewFilterId,
  usedBy
}) => {
  const title = filterId !== undefined ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.filterLists.editFilterHeader.filterListTitle",
    defaultMessage: "Filter list {filterId}",
    values: {
      filterId
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.filterLists.editFilterHeader.createFilterListTitle",
    defaultMessage: "Create new filter list"
  });
  let idField;
  let descriptionField;
  let usedByElement;
  if (filterId === undefined) {
    const msg = _i18n.i18n.translate('xpack.ml.settings.filterLists.editFilterHeader.allowedCharactersDescription', {
      defaultMessage: 'Use lowercase alphanumerics (a-z and 0-9), hyphens or underscores;' + ' must start and end with an alphanumeric character'
    });
    const helpText = isNewFilterIdInvalid === false ? msg : undefined;
    const error = isNewFilterIdInvalid === true ? [msg] : undefined;
    idField = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.settings.filterLists.editFilterHeader.filterListIdAriaLabel",
        defaultMessage: "Filter list ID"
      }),
      helpText: helpText,
      error: error,
      isInvalid: isNewFilterIdInvalid
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      name: "new_filter_id",
      value: newFilterId,
      isInvalid: isNewFilterIdInvalid,
      onChange: e => updateNewFilterId(e.target.value),
      "data-test-subj": 'mlNewFilterListIdInput'
    }));
  }
  if (description !== undefined && description.length > 0) {
    descriptionField = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": 'mlNewFilterListDescriptionText'
    }, /*#__PURE__*/_react.default.createElement("p", null, description));
  } else {
    descriptionField = /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.settings.filterLists.editFilterList.addDescriptionText",
      defaultMessage: "Add a description"
    })));
  }
  if (filterId !== undefined) {
    if (usedBy !== undefined && usedBy.jobs.length > 0) {
      usedByElement = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        className: "ml-filter-list-usage"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.settings.filterLists.editFilterList.filterIsUsedInJobsDescription",
        defaultMessage: "This filter list is used in"
      })), /*#__PURE__*/_react.default.createElement(_filter_list_usage_popover.FilterListUsagePopover, {
        entityType: "detector",
        entityValues: usedBy.detectors
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.settings.filterLists.editFilterList.acrossText",
        defaultMessage: "across"
      })), /*#__PURE__*/_react.default.createElement(_filter_list_usage_popover.FilterListUsagePopover, {
        entityType: "job",
        entityValues: usedBy.jobs
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }));
    } else {
      usedByElement = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.settings.filterLists.editFilterList.filterIsNotUsedInJobsDescription",
        defaultMessage: "This filter list is not used by any jobs."
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }));
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.filterLists.editFilterList.totalItemsDescription",
    defaultMessage: "{totalItemCount, plural, one {# item} other {# items}} in total",
    values: {
      totalItemCount
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), idField, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, descriptionField), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_edit_description_popover.EditDescriptionPopover, {
    canCreateFilter: canCreateFilter,
    description: description,
    updateDescription: updateDescription
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), usedByElement);
};
exports.EditFilterListHeader = EditFilterListHeader;
EditFilterListHeader.propTypes = {
  canCreateFilter: _propTypes.default.bool.isRequired,
  filterId: _propTypes.default.string,
  newFilterId: _propTypes.default.string,
  isNewFilterIdInvalid: _propTypes.default.bool,
  updateNewFilterId: _propTypes.default.func.isRequired,
  totalItemCount: _propTypes.default.number.isRequired,
  description: _propTypes.default.string,
  updateDescription: _propTypes.default.func.isRequired,
  usedBy: _propTypes.default.object
};
EditFilterListHeader.displayName = 'EditFilterListHeader';