"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportedEvents = ImportedEvents;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _eui = require("@elastic/eui");
var _events_table = require("../events_table");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ImportedEvents({
  events,
  showRecurringWarning,
  includePastEvents,
  onCheckboxToggle,
  onEventDelete
}) {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.importedEvents.eventsToImportTitle",
    defaultMessage: "Events to import: {eventsCount}",
    values: {
      eventsCount: events.length
    }
  })), showRecurringWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.importedEvents.recurringEventsNotSupportedDescription",
    defaultMessage: "Recurring events not supported. Only the first event will be imported."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_events_table.EventsTable, {
    eventsList: events,
    onDeleteClick: onEventDelete
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "ml-include-past-events",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.importedEvents.includePastEventsLabel",
      defaultMessage: "Include past events"
    }),
    checked: includePastEvents,
    onChange: onCheckboxToggle
  })));
}
ImportedEvents.propTypes = {
  events: _propTypes.PropTypes.array.isRequired,
  showRecurringWarning: _propTypes.PropTypes.bool.isRequired,
  includePastEvents: _propTypes.PropTypes.bool.isRequired,
  onCheckboxToggle: _propTypes.PropTypes.func.isRequired,
  onEventDelete: _propTypes.PropTypes.func.isRequired
};