"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.analyticsMapRouteFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _resolvers = require("../../resolvers");
var _page = require("../../../data_frame_analytics/pages/job_map/page");
var _breadcrumbs = require("../../breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const analyticsMapRouteFactory = (navigateToPath, basePath) => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_FRAME_ANALYTICS_MAP),
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, null),
  title: _i18n.i18n.translate('xpack.ml.dataFrameAnalytics.analyticsMap.docTitle', {
    defaultMessage: 'Analytics Map'
  }),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('DATA_FRAME_ANALYTICS_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.dataFrameAnalyticsBreadcrumbs.analyticsMapLabel', {
      defaultMessage: 'Analytics Map'
    })
  }],
  enableDatePicker: true,
  'data-test-subj': 'mlPageAnalyticsMap'
});
exports.analyticsMapRouteFactory = analyticsMapRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetDataFrameAnalytics'], (0, _resolvers.basicResolvers)());
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_page.Page, null));
};