"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.analyticsJobExplorationRouteFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _mlUrlState = require("@kbn/ml-url-state");
var _resolvers = require("../../resolvers");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _analytics_exploration = require("../../../data_frame_analytics/pages/analytics_exploration");
var _breadcrumbs = require("../../breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const analyticsJobExplorationRouteFactory = (navigateToPath, basePath) => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION),
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, null),
  title: _i18n.i18n.translate('xpack.ml.dataFrameAnalytics.exploration.docTitle', {
    defaultMessage: 'Results Explorer'
  }),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('DATA_FRAME_ANALYTICS_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.dataFrameAnalyticsBreadcrumbs.dataFrameExplorationLabel', {
      defaultMessage: 'Results Explorer'
    })
  }]
});
exports.analyticsJobExplorationRouteFactory = analyticsJobExplorationRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetDataFrameAnalytics'], (0, _resolvers.basicResolvers)());
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const jobId = globalState === null || globalState === void 0 ? void 0 : globalState.ml.jobId;
  const analysisType = globalState === null || globalState === void 0 ? void 0 : globalState.ml.analysisType;
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_analytics_exploration.Page, {
    jobId,
    analysisType
  }));
};