"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.analyticsJobsCreationRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _queryString = require("query-string");
var _i18n = require("@kbn/i18n");
var _ml = require("../../../contexts/ml");
var _locator = require("../../../../locator");
var _kibana = require("../../../contexts/kibana");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _resolvers = require("../../resolvers");
var _analytics_creation = require("../../../data_frame_analytics/pages/analytics_creation");
var _breadcrumbs = require("../../breadcrumbs");
var _load_new_job_capabilities = require("../../../services/new_job_capabilities/load_new_job_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const analyticsJobsCreationRouteFactory = (navigateToPath, basePath) => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_FRAME_ANALYTICS_CREATE_JOB),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  title: _i18n.i18n.translate('xpack.ml.dataFrameAnalytics.createJob.docTitle', {
    defaultMessage: 'Create Job'
  }),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('DATA_FRAME_ANALYTICS_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.dataFrameAnalyticsBreadcrumbs.dataFrameCreationLabel', {
      defaultMessage: 'Create Job'
    })
  }]
});
exports.analyticsJobsCreationRouteFactory = analyticsJobsCreationRouteFactory;
const PageWrapper = ({
  location
}) => {
  const {
    index,
    jobId,
    savedSearchId
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const {
    services: {
      data: {
        dataViews: dataViewsService
      },
      savedSearch: savedSearchService
    }
  } = (0, _kibana.useMlKibana)();
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetDataFrameAnalytics', 'canCreateDataFrameAnalytics'], {
    ...(0, _resolvers.basicResolvers)(),
    analyticsFields: () => (0, _load_new_job_capabilities.loadNewJobCapabilities)(index, savedSearchId, dataViewsService, savedSearchService, _load_new_job_capabilities.DATA_FRAME_ANALYTICS)
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_ml.DataSourceContextProvider, null, /*#__PURE__*/_react.default.createElement(_analytics_creation.Page, {
    jobId: jobId
  })));
};