"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBreadcrumbWithUrlForApp = exports.breadcrumbOnClickFactory = exports.TRAINED_MODELS = exports.SETTINGS_BREADCRUMB = exports.ML_BREADCRUMB = exports.LOG_RATE_ANALYSIS = exports.LOG_PATTERN_ANALYSIS = exports.FILTER_LISTS_BREADCRUMB = exports.DATA_VISUALIZER_BREADCRUMB = exports.DATA_FRAME_ANALYTICS_BREADCRUMB = exports.DATA_DRIFT_BREADCRUMB = exports.CREATE_JOB_BREADCRUMB = exports.CHANGE_POINT_DETECTION = exports.CALENDAR_MANAGEMENT_BREADCRUMB = exports.ANOMALY_DETECTION_BREADCRUMB = exports.AIOPS_BREADCRUMB_LOG_RATE_ANALYSIS = exports.AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS = exports.AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ML_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.machineLearningBreadcrumbLabel', {
    defaultMessage: 'Machine Learning'
  }),
  href: '/'
});
exports.ML_BREADCRUMB = ML_BREADCRUMB;
const SETTINGS_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.settingsBreadcrumbLabel', {
    defaultMessage: 'Settings'
  }),
  href: '/settings',
  deepLinkId: 'ml:settings'
});
exports.SETTINGS_BREADCRUMB = SETTINGS_BREADCRUMB;
const ANOMALY_DETECTION_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.anomalyDetectionBreadcrumbLabel', {
    defaultMessage: 'Anomaly Detection'
  }),
  href: '/jobs',
  deepLinkId: 'ml:anomalyDetection'
});
exports.ANOMALY_DETECTION_BREADCRUMB = ANOMALY_DETECTION_BREADCRUMB;
const DATA_FRAME_ANALYTICS_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.dataFrameAnalyticsLabel', {
    defaultMessage: 'Data Frame Analytics'
  }),
  href: '/data_frame_analytics',
  deepLinkId: 'ml:dataFrameAnalytics'
});
exports.DATA_FRAME_ANALYTICS_BREADCRUMB = DATA_FRAME_ANALYTICS_BREADCRUMB;
const TRAINED_MODELS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.modelManagementLabel', {
    defaultMessage: 'Model Management'
  }),
  href: '/trained_models',
  deepLinkId: 'ml:modelManagement'
});
exports.TRAINED_MODELS = TRAINED_MODELS;
const DATA_VISUALIZER_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.datavisualizerBreadcrumbLabel', {
    defaultMessage: 'Data Visualizer'
  }),
  href: '/datavisualizer',
  deepLinkId: 'ml:dataVisualizer'
});

// we need multiple AIOPS_BREADCRUMB breadcrumb items as they each need to link
// to each of the AIOps pages.
exports.DATA_VISUALIZER_BREADCRUMB = DATA_VISUALIZER_BREADCRUMB;
const AIOPS_BREADCRUMB_LOG_RATE_ANALYSIS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbLabel', {
    defaultMessage: 'AIOps Labs'
  }),
  href: '/aiops/log_rate_analysis_index_select'
});
exports.AIOPS_BREADCRUMB_LOG_RATE_ANALYSIS = AIOPS_BREADCRUMB_LOG_RATE_ANALYSIS;
const AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbLabel', {
    defaultMessage: 'AIOps Labs'
  }),
  href: '/aiops/log_categorization_index_select'
});
exports.AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS = AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS;
const AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbLabel', {
    defaultMessage: 'AIOps Labs'
  }),
  href: '/aiops/change_point_detection_index_select'
});
exports.AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION = AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION;
const LOG_RATE_ANALYSIS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiops.logRateAnalysisBreadcrumbLabel', {
    defaultMessage: 'Log Rate Analysis'
  }),
  href: '/aiops/log_rate_analysis_index_select',
  deepLinkId: 'ml:logRateAnalysis'
});
exports.LOG_RATE_ANALYSIS = LOG_RATE_ANALYSIS;
const LOG_PATTERN_ANALYSIS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiops.logPatternAnalysisBreadcrumbLabel', {
    defaultMessage: 'Log Pattern Analysis'
  }),
  href: '/aiops/log_categorization_index_select',
  deepLinkId: 'ml:logPatternAnalysis'
});
exports.LOG_PATTERN_ANALYSIS = LOG_PATTERN_ANALYSIS;
const CHANGE_POINT_DETECTION = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiops.changePointDetectionBreadcrumbLabel', {
    defaultMessage: 'Change Point Detection'
  }),
  href: '/aiops/change_point_detection_index_select',
  deepLinkId: 'ml:changePointDetections'
});
exports.CHANGE_POINT_DETECTION = CHANGE_POINT_DETECTION;
const CREATE_JOB_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.createJobsBreadcrumbLabel', {
    defaultMessage: 'Create job'
  }),
  href: '/jobs/new_job'
});
exports.CREATE_JOB_BREADCRUMB = CREATE_JOB_BREADCRUMB;
const CALENDAR_MANAGEMENT_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.calendarManagementLabel', {
    defaultMessage: 'Calendar management'
  }),
  href: '/settings/calendars_list',
  deepLinkId: 'ml:calendarSettings'
});
exports.CALENDAR_MANAGEMENT_BREADCRUMB = CALENDAR_MANAGEMENT_BREADCRUMB;
const FILTER_LISTS_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.filterListsLabel', {
    defaultMessage: 'Filter lists'
  }),
  href: '/settings/filter_lists',
  deepLinkId: 'ml:filterListsSettings'
});
exports.FILTER_LISTS_BREADCRUMB = FILTER_LISTS_BREADCRUMB;
const DATA_DRIFT_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.dataComparisonLabel', {
    defaultMessage: 'Data drift'
  }),
  href: '/data_drift_index_select',
  deepLinkId: 'ml:dataDrift'
});
exports.DATA_DRIFT_BREADCRUMB = DATA_DRIFT_BREADCRUMB;
const breadcrumbs = {
  ML_BREADCRUMB,
  SETTINGS_BREADCRUMB,
  ANOMALY_DETECTION_BREADCRUMB,
  DATA_FRAME_ANALYTICS_BREADCRUMB,
  TRAINED_MODELS,
  DATA_DRIFT_BREADCRUMB,
  DATA_VISUALIZER_BREADCRUMB,
  AIOPS_BREADCRUMB_LOG_RATE_ANALYSIS,
  AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS,
  AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION,
  LOG_RATE_ANALYSIS,
  LOG_PATTERN_ANALYSIS,
  CHANGE_POINT_DETECTION,
  CREATE_JOB_BREADCRUMB,
  CALENDAR_MANAGEMENT_BREADCRUMB,
  FILTER_LISTS_BREADCRUMB
};
const breadcrumbOnClickFactory = (path, navigateToPath) => {
  return e => {
    e.preventDefault();
    navigateToPath(path);
  };
};
exports.breadcrumbOnClickFactory = breadcrumbOnClickFactory;
const getBreadcrumbWithUrlForApp = (breadcrumbName, navigateToPath, basePath) => {
  return {
    text: breadcrumbs[breadcrumbName].text,
    ...(navigateToPath ? {
      href: `${basePath}/app/ml${breadcrumbs[breadcrumbName].href}`,
      deepLinkId: breadcrumbs[breadcrumbName].deepLinkId,
      onClick: breadcrumbOnClickFactory(breadcrumbs[breadcrumbName].href, navigateToPath)
    } : {})
  };
};
exports.getBreadcrumbWithUrlForApp = getBreadcrumbWithUrlForApp;