"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getModelStateColor = void 0;
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getModelStateColor = state => {
  switch (state) {
    case _mlTrainedModelsUtils.MODEL_STATE.DOWNLOADED:
      return {
        color: 'subdued',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.downloadedName', {
          defaultMessage: 'Ready to deploy'
        })
      };
    case _mlTrainedModelsUtils.MODEL_STATE.DOWNLOADING:
      return {
        color: 'warning',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.downloadingName', {
          defaultMessage: 'Downloading...'
        })
      };
    case _mlTrainedModelsUtils.MODEL_STATE.STARTED:
      return {
        color: 'success',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.startedName', {
          defaultMessage: 'Deployed'
        })
      };
    case _mlTrainedModelsUtils.MODEL_STATE.STARTING:
      return {
        color: 'success',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.startingName', {
          defaultMessage: 'Starting deployment...'
        })
      };
    case _mlTrainedModelsUtils.MODEL_STATE.STOPPING:
      return {
        color: 'accent',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.stoppingName', {
          defaultMessage: 'Stopping deployment...'
        })
      };
    case _mlTrainedModelsUtils.MODEL_STATE.NOT_DOWNLOADED:
      return {
        color: '#d4dae5',
        name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelState.notDownloadedName', {
          defaultMessage: 'Not downloaded'
        })
      };
    default:
      return null;
  }
};
exports.getModelStateColor = getModelStateColor;