"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _common = require("@kbn/field-formats-plugin/common");
var _react2 = require("@emotion/react");
var _expanded_row = require("../../model_management/expanded_row");
var _allocated_models = require("./allocated_models");
var _use_field_formatter = require("../../contexts/kibana/use_field_formatter");
var _memory_tree_map = require("../memory_tree_map");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var TAB;
(function (TAB) {
  TAB[TAB["DETAILS"] = 0] = "DETAILS";
  TAB[TAB["MEMORY_USAGE"] = 1] = "MEMORY_USAGE";
})(TAB || (TAB = {}));
const ExpandedRow = ({
  item
}) => {
  const bytesFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.BYTES);
  const [selectedTab, setSelectedTab] = (0, _react.useState)(TAB.DETAILS);
  const formatToListItems = (0, _expanded_row.useListItemsFormatter)();
  const {
    allocated_models: allocatedModels,
    attributes,
    memory_overview: memoryOverview,
    id,
    ...details
  } = (0, _lodash.cloneDeep)(item);

  // Process node attributes
  attributes['ml.machine_memory'] = bytesFormatter(attributes['ml.machine_memory']);
  attributes['ml.max_jvm_size'] = bytesFormatter(attributes['ml.max_jvm_size']);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        width: 100%;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === TAB.DETAILS,
    onClick: () => setSelectedTab(TAB.DETAILS)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.nodesList.expandedRow.detailsTabTitle",
    defaultMessage: "Details"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === TAB.MEMORY_USAGE,
    onClick: () => setSelectedTab(TAB.MEMORY_USAGE)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.nodesList.expandedRow.memoryTabTitle",
    defaultMessage: "Memory usage"
  }))), selectedTab === TAB.DETAILS ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: 's'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 'xs'
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.nodesList.expandedRow.detailsTitle",
    defaultMessage: "Details"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    listItems: formatToListItems(details)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 'xs'
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.nodesList.expandedRow.attributesTitle",
    defaultMessage: "Attributes"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    listItems: formatToListItems(attributes)
  })))), allocatedModels.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 'xs'
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.nodesList.expandedRow.allocatedModelsTitle",
    defaultMessage: "Allocated trained models"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_allocated_models.AllocatedModels, {
    models: allocatedModels
  }))) : null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_memory_tree_map.JobMemoryTreeMap, {
    node: item.name
  })));
};
exports.ExpandedRow = ExpandedRow;