"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SETUP_RESULTS_WIDTH = exports.ModuleJobs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _page = require("../page");
var _job_item = require("./job_item");
var _edit_job = require("./edit_job");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SETUP_RESULTS_WIDTH = '200px';
exports.SETUP_RESULTS_WIDTH = SETUP_RESULTS_WIDTH;
const ModuleJobs = ({
  jobs,
  jobPrefix,
  jobOverrides,
  saveState,
  existingGroupIds,
  onJobOverridesChange
}) => {
  const isSaving = saveState === _page.SAVE_STATE.SAVING;
  const [jobToEdit, setJobToEdit] = (0, _react.useState)(null);
  const onFlyoutClose = result => {
    setJobToEdit(null);
    if (result === null) {
      return;
    }
    onJobOverridesChange(result);
  };
  const getJobOverride = job => {
    return jobOverrides[job.id];
  };
  const editJobFlyout = jobToEdit !== null ? /*#__PURE__*/_react.default.createElement(_edit_job.EditJob, {
    job: jobToEdit,
    jobOverride: getJobOverride(jobToEdit),
    onClose: onFlyoutClose,
    existingGroupIds: existingGroupIds
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.jobsTitle",
    defaultMessage: "Jobs"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), saveState !== _page.SAVE_STATE.SAVING && saveState !== _page.SAVE_STATE.NOT_SAVED && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: SETUP_RESULTS_WIDTH
    },
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround",
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.jobLabel",
    defaultMessage: "Job"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.datafeedLabel",
    defaultMessage: "Datafeed"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.runningLabel",
    defaultMessage: "Running"
  })))))), /*#__PURE__*/_react.default.createElement("ul", null, jobs.map((job, i) => /*#__PURE__*/_react.default.createElement("li", {
    key: job.id
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_job_item.JobItem, {
    jobPrefix: jobPrefix,
    job: job,
    jobOverride: getJobOverride(job),
    isSaving: isSaving,
    onEditRequest: () => setJobToEdit(job)
  }))), i < jobs.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  })))), editJobFlyout);
};
exports.ModuleJobs = ModuleJobs;