"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _split_cards = require("../split_cards");
var _detector_title = require("../detector_title");
var _anomaly_chart = require("../../../charts/anomaly_chart");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartGrid = ({
  aggFieldPairList,
  chartSettings,
  splitField,
  fieldValues,
  lineChartsData,
  modelData,
  anomalyData,
  deleteDetector,
  jobType,
  loading = false
}) => {
  const animateSplit = (0, _split_cards.useAnimateSplit)();
  return /*#__PURE__*/_react.default.createElement(_split_cards.SplitCards, {
    fieldValues: fieldValues,
    splitField: splitField,
    numberOfDetectors: aggFieldPairList.length,
    jobType: jobType,
    animate: animateSplit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: chartSettings.cols
  }, aggFieldPairList.map((af, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: i,
    "data-test-subj": `mlDetector ${i}`
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_detector_title.DetectorTitle, {
    index: i,
    agg: aggFieldPairList[i].agg,
    field: aggFieldPairList[i].field,
    deleteDetector: deleteDetector
  }), /*#__PURE__*/_react.default.createElement(_anomaly_chart.AnomalyChart, {
    chartType: _anomaly_chart.CHART_TYPE.LINE,
    chartData: lineChartsData[i],
    modelData: modelData[i],
    anomalyData: anomalyData[i],
    height: chartSettings.height,
    width: chartSettings.width,
    loading: loading
  }))))));
};
exports.ChartGrid = ChartGrid;