"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectorTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetectorTitle = ({
  index,
  agg,
  field,
  byField,
  deleteDetector,
  children
}) => {
  const splitField = children === false && byField !== undefined ? byField.field : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", {
    style: {
      fontSize: 'small'
    },
    "data-test-subj": "mlDetectorTitle"
  }, getTitle(agg, field, splitField))), children !== false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '100%',
      maxWidth: '400px'
    }
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, deleteDetector !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: 'danger',
    onClick: () => deleteDetector(index),
    iconType: "cross",
    size: "s",
    "aria-label": "Next"
  })));
};
exports.DetectorTitle = DetectorTitle;
function getTitle(agg, field, splitField) {
  const title = `${agg.title}(${field.name})`;
  if (splitField === null) {
    return title;
  } else {
    return _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.detectorTitle.placeholder', {
      defaultMessage: '{title} split by {field}',
      values: {
        title,
        field: splitField.name
      }
    });
  }
}