"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategorizationView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _metric_selection = require("./metric_selection");
var _metric_selection_summary = require("./metric_selection_summary");
var _settings = require("./settings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CategorizationView = ({
  isActive,
  setCanProceed
}) => {
  const [categoryFieldValid, setCategoryFieldValid] = (0, _react.useState)(false);
  const [settingsValid, setSettingsValid] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (typeof setCanProceed === 'function') {
      setCanProceed(categoryFieldValid && settingsValid);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [categoryFieldValid, settingsValid]);
  return isActive === false ? /*#__PURE__*/_react.default.createElement(_metric_selection_summary.CategorizationDetectorsSummary, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_metric_selection.CategorizationDetectors, {
    setIsValid: setCategoryFieldValid
  }), categoryFieldValid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), /*#__PURE__*/_react.default.createElement(_settings.CategorizationSettings, {
    setIsValid: setSettingsValid
  })));
};
exports.CategorizationView = CategorizationView;