"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategorizationPerPartitionSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CategorizationPerPartitionSwitch = () => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [enablePerPartitionCategorization, setEnablePerPartitionCategorization] = (0, _react.useState)(jobCreator.perPartitionCategorization);
  const toggleEnablePerPartitionCategorization = (0, _react.useCallback)(() => setEnablePerPartitionCategorization(!enablePerPartitionCategorization), [enablePerPartitionCategorization]);
  (0, _react.useEffect)(() => {
    setEnablePerPartitionCategorization(jobCreator.perPartitionCategorization);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  (0, _react.useEffect)(() => {
    // also turn off stop on warn if per_partition_categorization is turned off
    if (enablePerPartitionCategorization === false) {
      jobCreator.perPartitionStopOnWarn = false;
    }
    jobCreator.perPartitionCategorization = enablePerPartitionCategorization;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [enablePerPartitionCategorization]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "categorizationPerPartitionSwitch",
    disabled: false,
    checked: enablePerPartitionCategorization,
    onChange: toggleEnablePerPartitionCategorization,
    "data-test-subj": "mlJobWizardSwitchCategorizationPerPartition",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.perPartitionCategorizationSwitchLabel",
      defaultMessage: "Enable per-partition categorization"
    })
  });
};
exports.CategorizationPerPartitionSwitch = CategorizationPerPartitionSwitch;