"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Line = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _settings = require("../common/settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SPEC_ID = 'line';
const lineSeriesStyle = {
  ..._settings.seriesStyle
};
const Line = ({
  chartData
}) => {
  const {
    LINE_COLOR
  } = (0, _settings.useChartColors)();
  return /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: SPEC_ID,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'time',
    yAccessors: ['value'],
    data: chartData,
    curve: _charts.CurveType.CURVE_MONOTONE_X,
    lineSeriesStyle: lineSeriesStyle,
    color: LINE_COLOR
  });
};
exports.Line = Line;