"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.redirectToADJobWizards = redirectToADJobWizards;
var _locator = require("../../../../../common/constants/locator");
var _locator2 = require("../../../../locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function redirectToADJobWizards(categorizationType, dataView, field, partitionField, stopOnWarn, query, timeRange, share) {
  const locator = share.url.locators.get(_locator.ML_APP_LOCATOR);
  const url = await locator.getUrl({
    page: _locator2.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_FROM_PATTERN_ANALYSIS,
    pageState: {
      categorizationType,
      dataViewId: dataView.id,
      field: field.name,
      partitionField: (partitionField === null || partitionField === void 0 ? void 0 : partitionField.name) || null,
      stopOnWarn,
      from: timeRange.from,
      to: timeRange.to,
      query: JSON.stringify(query)
    }
  });
  window.open(url, '_blank');
}