"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeRangeSelector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./_time_range_selector.scss");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _managed_jobs_warning_callout = require("../../confirm_modals/managed_jobs_warning_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TimeRangeSelector extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "setStartTab", tab => {
      this.setState({
        startTab: tab
      });
      switch (tab) {
        case 0:
          this.setStartTime(undefined);
          break;
        case 1:
          this.setStartTime(this.now);
          break;
        case 2:
          this.setStartTime(this.twoWeeksAgo);
          break;
        default:
          break;
      }
    });
    (0, _defineProperty2.default)(this, "setEndTab", tab => {
      this.setState({
        endTab: tab
      });
      switch (tab) {
        case 0:
          this.setEndTime(undefined);
          break;
        case 1:
          this.setEndTime(this.now);
          break;
        default:
          break;
      }
    });
    (0, _defineProperty2.default)(this, "setStartTime", time => {
      this.props.setStartTime(time);
    });
    (0, _defineProperty2.default)(this, "setEndTime", time => {
      this.props.setEndTime(time);
    });
    this.state = {
      startTab: 0,
      endTab: 1
    };
    this.latestTimestamp = this.props.startTime;
    this.now = this.props.now;
    this.twoWeeksAgo = (0, _moment.default)(this.now).subtract(2, 'weeks').startOf('day');
  }
  getTabItems() {
    const datePickerTimes = {
      start: _moment.default.isMoment(this.props.startTime) ? this.props.startTime : this.latestTimestamp,
      end: _moment.default.isMoment(this.props.endTime) ? this.props.endTime : this.now
    };
    const formattedLatestStartTime = this.latestTimestamp.format(_mlDateUtils.TIME_FORMAT);

    // Show different labels for the start time depending on whether
    // the job has seen any data yet
    const showContinueLabels = this.latestTimestamp.valueOf() > 0;
    const startLabels = showContinueLabels === true ? [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.startDatafeedModal.continueFromStartTimeLabel",
      defaultMessage: "Continue from {formattedLatestStartTime}",
      values: {
        formattedLatestStartTime
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.startDatafeedModal.continueFromNowLabel",
      defaultMessage: "Continue from now"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.startDatafeedModal.continueFromSpecifiedTimeLabel",
      defaultMessage: "Continue from specified time"
    })] : [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.startDatafeedModal.startAtBeginningOfDataLabel",
      defaultMessage: "Start at beginning of data"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.startDatafeedModal.startFromNowLabel",
      defaultMessage: "Start from now"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.startDatafeedModal.specifyStartTimeLabel",
      defaultMessage: "Specify start time"
    })];
    const startItems = [{
      index: 0,
      label: startLabels[0]
    }, {
      index: 1,
      label: startLabels[1]
    }, {
      index: 2,
      label: startLabels[2],
      body: /*#__PURE__*/_react.default.createElement(DatePickerWithInput, {
        date: datePickerTimes.start,
        onChange: this.setStartTime,
        maxDate: datePickerTimes.end,
        setIsValid: this.props.setTimeRangeValid,
        tab: this.state.startTab
      })
    }];
    const endItems = [{
      index: 0,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.startDatafeedModal.noEndTimeLabel",
        defaultMessage: "No end time (Real-time search)"
      })
    }, {
      index: 1,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.startDatafeedModal.specifyEndTimeLabel",
        defaultMessage: "Specify end time"
      }),
      body: /*#__PURE__*/_react.default.createElement(DatePickerWithInput, {
        date: datePickerTimes.end,
        onChange: this.setEndTime,
        minDate: datePickerTimes.start,
        setIsValid: this.props.setTimeRangeValid,
        tab: this.state.endTab
      })
    }];
    return {
      startItems,
      endItems
    };
  }
  render() {
    const {
      startItems,
      endItems
    } = this.getTabItems();
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "time-range-selector"
    }, this.props.hasManagedJob === true && this.state.endTab !== 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managed_jobs_warning_callout.ManagedJobsWarningCallout, {
      jobsCount: this.props.jobsCount,
      message: _i18n.i18n.translate('xpack.ml.jobsList.startDatafeedsModal.startManagedDatafeedsDescription', {
        defaultMessage: '{jobsCount, plural, one {This job} other {At least one of these jobs}} is preconfigured by Elastic; starting {jobsCount, plural, one {it} other {them}} with a specific end time might impact other parts of the product.',
        values: {
          jobsCount: this.props.jobsCount
        }
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(TabStack, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.startDatafeedModal.searchStartTimeTitle",
        defaultMessage: "Search start time"
      }),
      items: startItems,
      switchState: this.state.startTab,
      switchFunc: this.setStartTab
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(TabStack, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.startDatafeedModal.searchEndTimeTitle",
        defaultMessage: "Search end time"
      }),
      items: endItems,
      switchState: this.state.endTab,
      switchFunc: this.setEndTab
    }))));
  }
}
exports.TimeRangeSelector = TimeRangeSelector;
function TabStack({
  title,
  items,
  switchState,
  switchFunc
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "time-range-section"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "time-range-section-title"
  }, title), /*#__PURE__*/_react.default.createElement("ul", {
    className: "tab-stack"
  }, items.map((item, i) => {
    let className = '';
    if (switchState === item.index) {
      className += 'active ';
    }
    if (item.body !== undefined) {
      className += 'has-body ';
    }
    return /*#__PURE__*/_react.default.createElement("li", {
      key: i,
      className: className
    }, /*#__PURE__*/_react.default.createElement("a", {
      onClick: () => switchFunc(item.index),
      onKeyUp: () => {}
    }, item.label), item.body !== undefined && /*#__PURE__*/_react.default.createElement("div", {
      className: "body"
    }, item.body));
  })));
}
const DatePickerWithInput = ({
  date,
  onChange,
  minDate,
  setIsValid,
  tab
}) => {
  const [dateString, setDateString] = (0, _react.useState)(date.format(_mlDateUtils.TIME_FORMAT));
  const [currentTab, setCurrentTab] = (0, _react.useState)(tab);
  (0, _react.useEffect)(() => {
    if (currentTab !== tab) {
      // if the tab has changed, reset the text to be the same as the date prop
      setDateString(date.format(_mlDateUtils.TIME_FORMAT));
      setCurrentTab(tab);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [tab]);
  function onTextChange(e) {
    const val = e.target.value;
    setDateString(val);
    const newDate = (0, _moment.default)(val);
    if (newDate.isValid()) {
      setIsValid(true);
      onChange(newDate);
    } else {
      setIsValid(false);
    }
  }
  function onCalendarChange(newDate) {
    setDateString(newDate.format(_mlDateUtils.TIME_FORMAT));
    setIsValid(true);
    onChange(newDate);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: dateString,
    onChange: onTextChange,
    placeholder: _mlDateUtils.TIME_FORMAT,
    "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.startDatafeedModal.enterDateText"', {
      defaultMessage: 'Enter date'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    selected: date,
    onChange: onCalendarChange,
    minDate: minDate,
    inline: true,
    showTimeSelect: true
  }));
};
TimeRangeSelector.propTypes = {
  startTime: _propTypes.default.object.isRequired,
  endTime: _propTypes.default.object,
  setStartTime: _propTypes.default.func.isRequired,
  setEndTime: _propTypes.default.func.isRequired
};