"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResetJobModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
var _jobs_list = require("../../../../../../common/constants/jobs_list");
var _open_jobs_warning_callout = require("./open_jobs_warning_callout");
var _jobs_utils = require("../../../jobs_utils");
var _managed_jobs_warning_callout = require("../confirm_modals/managed_jobs_warning_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResetJobModal = ({
  setShowFunction,
  unsetShowFunction,
  refreshJobs
}) => {
  const [resetting, setResetting] = (0, _react.useState)(false);
  const [modalVisible, setModalVisible] = (0, _react.useState)(false);
  const [jobIds, setJobIds] = (0, _react.useState)([]);
  const [jobs, setJobs] = (0, _react.useState)([]);
  const [hasManagedJob, setHasManagedJob] = (0, _react.useState)(false);
  const [deleteUserAnnotations, setDeleteUserAnnotations] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (typeof setShowFunction === 'function') {
      setShowFunction(showModal);
    }
    return () => {
      if (typeof unsetShowFunction === 'function') {
        unsetShowFunction();
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const showModal = (0, _react.useCallback)(tempJobs => {
    setJobIds(tempJobs.map(({
      id
    }) => id));
    setJobs(tempJobs);
    setHasManagedJob(tempJobs.some(j => (0, _jobs_utils.isManagedJob)(j)));
    setModalVisible(true);
    setResetting(false);
    setDeleteUserAnnotations(false);
  }, []);
  const closeModal = (0, _react.useCallback)(() => {
    setModalVisible(false);
  }, []);
  const resetJob = (0, _react.useCallback)(async () => {
    setResetting(true);
    await (0, _utils.resetJobs)(jobIds, deleteUserAnnotations);
    closeModal();
    setTimeout(() => {
      refreshJobs();
    }, _jobs_list.RESETTING_JOBS_REFRESH_INTERVAL_MS);
  }, [closeModal, deleteUserAnnotations, jobIds, refreshJobs]);
  if (modalVisible === false || jobIds.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "mlResetJobConfirmModal",
    onClose: closeModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.resetJobModal.resetJobsTitle",
    defaultMessage: "Reset {jobsCount, plural, one {{jobId}} other {# jobs}}?",
    values: {
      jobsCount: jobIds.length,
      jobId: jobIds[0]
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_open_jobs_warning_callout.OpenJobsWarningCallout, {
    jobs: jobs
  }), hasManagedJob === true ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managed_jobs_warning_callout.ManagedJobsWarningCallout, {
    jobsCount: jobIds.length,
    action: _i18n.i18n.translate('xpack.ml.jobsList.startDatafeedsModal.resetManagedDatafeedsDescription', {
      defaultMessage: 'resetting'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.resetJobModal.resetMultipleJobsDescription",
    defaultMessage: "Resetting {jobsCount, plural, one {a job} other {multiple jobs}} can be time consuming. {jobsCount, plural, one {It} other {They}} will be reset in the background and may not be updated in the jobs list instantly.",
    values: {
      jobsCount: jobIds.length
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.ml.jobsList.resetJobModal.deleteUserAnnotations', {
      defaultMessage: 'Delete annotations.'
    }),
    checked: deleteUserAnnotations,
    onChange: e => setDeleteUserAnnotations(e.target.checked)
  })))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    disabled: resetting
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.resetJobModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: resetJob,
    fill: true,
    disabled: resetting,
    color: "danger",
    "data-test-subj": "mlResetJobConfirmModalButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.resetJobModal.resetButtonLabel",
    defaultMessage: "Reset"
  })))));
};
exports.ResetJobModal = ResetJobModal;