"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupList = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _job_group = require("../../../job_group");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Check({
  group,
  selectedGroups
}) {
  if (selectedGroups[group.id] !== undefined) {
    if (selectedGroups[group.id].partial) {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "check selected"
      }, /*#__PURE__*/_react.default.createElement("span", null, "\u2014"));
    } else {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "check selected"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check"
      }));
    }
  } else {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "check"
    });
  }
}
class GroupList extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "selectGroup", group => {
      this.props.selectGroup(group);
    });
    (0, _defineProperty2.default)(this, "moveUp", (event, index) => {
      event.preventDefault();
      if (index < 0) {
        return;
      } else if (index > 0) {
        this.selectItems[index - 1].focus();
      }
    });
    (0, _defineProperty2.default)(this, "moveDown", (event, index) => {
      event.preventDefault();
      if (index < this.selectItems.length - 1) {
        this.selectItems[index + 1].focus();
      }
    });
    (0, _defineProperty2.default)(this, "handleKeyDown", (event, group, index) => {
      switch (event.key) {
        case _eui.keys.ENTER:
          this.selectGroup(group);
          break;
        case _eui.keys.SPACE:
          this.selectGroup(group);
          break;
        case _eui.keys.ARROW_DOWN:
          this.moveDown(event, index);
          break;
        case _eui.keys.ARROW_UP:
          this.moveUp(event, index);
          break;
      }
    });
    (0, _defineProperty2.default)(this, "setRef", (ref, index) => {
      this.selectItems[index] = ref;
    });
    this.state = {
      groups: []
    };
    // keep track of each of the group item refs
    this.selectItems = [];
  }
  render() {
    const {
      selectedGroups,
      groups
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "m"
    }, groups.map((g, index) => /*#__PURE__*/_react.default.createElement("div", {
      tabIndex: '0',
      onKeyDown: event => this.handleKeyDown(event, g, index),
      key: g.id,
      className: "group-item",
      onClick: () => this.selectGroup(g),
      ref: ref => this.setRef(ref, index)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_job_group.JobGroup, {
      name: g.id
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(Check, {
      group: g,
      selectedGroups: selectedGroups
    }))))));
  }
}
exports.GroupList = GroupList;
GroupList.propTypes = {
  selectedGroups: _propTypes.default.object.isRequired,
  groups: _propTypes.default.array.isRequired,
  selectGroup: _propTypes.default.func.isRequired
};