"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Detectors = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_service = require("../../../../../services/job_service");
var _string_utils = require("../../../../../util/string_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Detectors extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onDescriptionChange", (e, i) => {
      const jobDetectorDescriptions = this.state.detectorDescriptions;
      jobDetectorDescriptions[i] = e.target.value;
      this.setDetectorDescriptions({
        jobDetectorDescriptions
      });
    });
    this.detectors = _job_service.mlJobService.getJobGroups().map(g => ({
      label: g.id
    }));
    this.state = {
      detectors: [],
      detectorDescriptions: []
    };
    this.setDetectorDescriptions = props.setDetectorDescriptions;
  }
  static getDerivedStateFromProps(props) {
    return {
      detectors: props.jobDetectors,
      detectorDescriptions: props.jobDetectorDescriptions
    };
  }
  render() {
    const {
      detectors,
      detectorDescriptions
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.editJobFlyout.detectors.title",
      defaultMessage: "Edit detector descriptions"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, detectorDescriptions.map((d, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: (0, _string_utils.detectorToString)(detectors[i]),
      key: i
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: d,
      onChange: e => this.onDescriptionChange(e, i)
    })))));
  }
}
exports.Detectors = Detectors;
Detectors.propTypes = {
  jobDetectors: _propTypes.default.array.isRequired,
  jobDetectorDescriptions: _propTypes.default.array.isRequired,
  setDetectorDescriptions: _propTypes.default.func.isRequired
};