"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Datafeed = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _job_utils = require("../../../../../../../common/util/job_utils");
var _ml_server_info = require("../../../../../services/ml_server_info");
var _parse_interval = require("../../../../../../../common/util/parse_interval");
var _ml_job_editor = require("../../ml_job_editor");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefaults(bucketSpan, jobDefaults) {
  const bucketSpanSeconds = bucketSpan !== undefined ? (0, _parse_interval.parseInterval)(bucketSpan).asSeconds() : '';
  return {
    queryDelay: '60s',
    frequency: (0, _job_utils.calculateDatafeedFrequencyDefaultSeconds)(bucketSpanSeconds) + 's',
    scrollSize: jobDefaults.datafeeds.scroll_size
  };
}
class Datafeed extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onQueryChange", query => {
      this.setDatafeed({
        datafeedQuery: query
      });
    });
    (0, _defineProperty2.default)(this, "onQueryDelayChange", e => {
      this.setDatafeed({
        datafeedQueryDelay: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onFrequencyChange", e => {
      this.setDatafeed({
        datafeedFrequency: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onScrollSizeChange", e => {
      this.setDatafeed({
        datafeedScrollSize: +e.target.value
      });
    });
    this.state = {
      query: '',
      queryDelay: '',
      frequency: '',
      scrollSize: '',
      defaults: {
        queryDelay: '',
        frequency: '',
        scrollSize: 0
      },
      jobDefaults: (0, _ml_server_info.getNewJobDefaults)()
    };
    this.setDatafeed = props.setDatafeed;
  }
  static getDerivedStateFromProps(props, state) {
    return {
      query: props.datafeedQuery,
      queryDelay: props.datafeedQueryDelay,
      frequency: props.datafeedFrequency,
      scrollSize: props.datafeedScrollSize,
      defaults: getDefaults(props.jobBucketSpan, state.jobDefaults)
    };
  }
  render() {
    const {
      query,
      queryDelay,
      frequency,
      scrollSize,
      defaults
    } = this.state;
    const {
      datafeedRunning
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), datafeedRunning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.editJobFlyout.datafeed.readOnlyCalloutText",
      defaultMessage: "Datafeed settings cannot be edited while the datafeed is running. Please stop the job if you wish to edit these settings."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.datafeed.queryLabel",
        defaultMessage: "Query"
      }),
      style: {
        maxWidth: 'inherit'
      }
    }, /*#__PURE__*/_react.default.createElement(_ml_job_editor.MLJobEditor, {
      mode: _ml_job_editor.ML_EDITOR_MODE.XJSON,
      value: query,
      onChange: this.onQueryChange,
      height: "200px",
      readOnly: datafeedRunning
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.datafeed.queryDelayLabel",
        defaultMessage: "Query delay"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: queryDelay,
      placeholder: defaults.queryDelay,
      onChange: this.onQueryDelayChange,
      disabled: datafeedRunning
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.datafeed.frequencyLabel",
        defaultMessage: "Frequency"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: frequency,
      placeholder: defaults.frequency,
      onChange: this.onFrequencyChange,
      disabled: datafeedRunning
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.datafeed.scrollSizeLabel",
        defaultMessage: "Scroll size"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: scrollSize,
      placeholder: defaults.scrollSize,
      onChange: this.onScrollSizeChange,
      disabled: datafeedRunning
    }))));
  }
}
exports.Datafeed = Datafeed;
Datafeed.propTypes = {
  datafeedRunning: _propTypes.default.bool.isRequired,
  datafeedQuery: _propTypes.default.string.isRequired,
  datafeedQueryDelay: _propTypes.default.string.isRequired,
  datafeedFrequency: _propTypes.default.string.isRequired,
  datafeedScrollSize: _propTypes.default.number.isRequired,
  jobBucketSpan: _propTypes.default.string.isRequired,
  setDatafeed: _propTypes.default.func.isRequired
};