"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAsObservable = useAsObservable;
var _react = require("react");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides an observable based on the input
 * preserving the reference.
 *
 * @param value
 */
function useAsObservable(value) {
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const subject = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(value), []);
  (0, _react.useEffect)(function updateSubject() {
    subject.next(value);
  }, [subject, value]);
  return (0, _react.useMemo)(() => subject.asObservable(), [subject]);
}