"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddedMapComponentWrapper = EmbeddedMapComponentWrapper;
var _react = _interopRequireWildcard(require("react"));
var _map_config = require("./map_config");
var _ml_embedded_map = require("../../components/ml_embedded_map");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EmbeddedMapComponentWrapper({
  seriesConfig
}) {
  const [layerList, setLayerList] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    if (seriesConfig.mapData && seriesConfig.mapData.length > 0) {
      setLayerList([(0, _map_config.getMLAnomaliesActualLayer)(seriesConfig.mapData), (0, _map_config.getMLAnomaliesTypicalLayer)(seriesConfig.mapData)]);
    }
  }, [seriesConfig]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "xpack.ml.explorer.embeddedMap",
    style: {
      width: '100%',
      height: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_embedded_map.MlEmbeddedMapComponent, {
    layerList: layerList
  }));
}