"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMapAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _mlUrlState = require("@kbn/ml-url-state");
var _kibana = require("../../../../../contexts/kibana");
var _locator = require("../../../../../../../common/constants/locator");
var _get_view_link_status = require("../action_view/get_view_link_status");
var _map_button = require("./map_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMapAction = () => {
  const mlLocator = (0, _kibana.useMlLocator)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const clickHandler = (0, _react.useCallback)(async item => {
    const globalStateClone = (0, _lodash.cloneDeep)(globalState || {});
    delete globalStateClone.ml;
    const path = await mlLocator.getUrl({
      page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_MAP,
      pageState: {
        jobId: item.id,
        globalState: globalStateClone
      }
    });
    await navigateToPath(path, false);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [globalState]);
  const action = (0, _react.useMemo)(() => ({
    isPrimary: true,
    name: item => /*#__PURE__*/_react.default.createElement(_map_button.MapButton, {
      item: item
    }),
    enabled: item => !(0, _get_view_link_status.getViewLinkStatus)(item).disabled,
    description: _map_button.mapActionButtonText,
    icon: 'graphApp',
    type: 'icon',
    onClick: clickHandler,
    'data-test-subj': 'mlAnalyticsJobMapButton'
  }), [clickHandler]);
  return {
    action
  };
};
exports.useMapAction = useMapAction;