"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteActionNameText = exports.DeleteActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _check_capabilities = require("../../../../../capabilities/check_capabilities");
var _common = require("../analytics_list/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteActionNameText = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.deleteActionNameText', {
  defaultMessage: 'Delete'
});
exports.deleteActionNameText = deleteActionNameText;
const DeleteActionName = ({
  isDisabled,
  item
}) => {
  if (isDisabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: (0, _common.isDataFrameAnalyticsRunning)(item.stats.state) ? _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.deleteActionDisabledToolTipContent', {
        defaultMessage: 'Stop the data frame analytics job in order to delete it.'
      }) : (0, _check_capabilities.createPermissionFailureMessage)('canStartStopDataFrameAnalytics')
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, deleteActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, deleteActionNameText);
};
exports.DeleteActionName = DeleteActionName;