"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutlierExploration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _color_range_legend = require("../../../../../components/color_range_legend");
var _scatterplot_matrix = require("../../../../../components/scatterplot_matrix");
var _common = require("../../../../common");
var _expandable_section = require("../expandable_section");
var _exploration_query_bar = require("../exploration_query_bar");
var _common2 = require("./common");
var _use_outlier_data = require("./use_outlier_data");
var _use_exploration_url_state = require("../../hooks/use_exploration_url_state");
var _data_view_prompt = require("../data_view_prompt");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OutlierExploration = /*#__PURE__*/_react.default.memo(({
  jobId
}) => {
  var _jobConfig$dest$resul, _jobConfig$analyzed_f, _jobConfig$analyzed_f2;
  const {
    dataView,
    dataViewErrorMessage,
    jobConfig,
    needsDestDataView
  } = (0, _common.useResultsViewConfig)(jobId);
  const [pageUrlState, setPageUrlState] = (0, _use_exploration_url_state.useExplorationUrlState)();
  const [searchQuery, setSearchQuery] = (0, _react.useState)(_common.defaultSearchQuery);
  const outlierData = (0, _use_outlier_data.useOutlierData)(dataView, jobConfig, searchQuery);
  const searchQueryUpdateHandler = (0, _react.useCallback)(update => {
    if (update.query) {
      setSearchQuery(update.query);
    }
    if (update.queryString !== pageUrlState.queryText) {
      setPageUrlState({
        queryText: update.queryString,
        queryLanguage: update.language
      });
    }
  }, [pageUrlState, setPageUrlState]);
  const query = {
    query: pageUrlState.queryText,
    language: pageUrlState.queryLanguage
  };
  const {
    columnsWithCharts,
    tableItems
  } = outlierData;
  const resultsField = (_jobConfig$dest$resul = jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.dest.results_field) !== null && _jobConfig$dest$resul !== void 0 ? _jobConfig$dest$resul : '';
  const featureCount = (0, _common2.getFeatureCount)(resultsField, tableItems);
  const colorRange = (0, _color_range_legend.useColorRange)(_color_range_legend.COLOR_RANGE.BLUE, _color_range_legend.COLOR_RANGE_SCALE.INFLUENCER, featureCount);

  // Show the color range only if feature influence is enabled.
  const showColorRange = (0, _mlDataFrameAnalyticsUtils.isOutlierAnalysis)(jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.analysis) && (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.analysis.outlier_detection.compute_feature_influence) === true;

  // Identify if the results index has a legacy feature influence format.
  // If feature influence was enabled for the legacy job we'll show a callout
  // with some additional information for a workaround.
  const showLegacyFeatureInfluenceFormatCallout = !needsDestDataView && (0, _mlDataFrameAnalyticsUtils.isOutlierAnalysis)(jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.analysis) && (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.analysis.outlier_detection.compute_feature_influence) === true && columnsWithCharts.findIndex(d => d.id === `${resultsField}.${_mlDataFrameAnalyticsUtils.FEATURE_INFLUENCE}`) === -1;
  const scatterplotFieldOptions = (0, _scatterplot_matrix.useScatterplotFieldOptions)(dataView, jobConfig === null || jobConfig === void 0 ? void 0 : (_jobConfig$analyzed_f = jobConfig.analyzed_fields) === null || _jobConfig$analyzed_f === void 0 ? void 0 : _jobConfig$analyzed_f.includes, jobConfig === null || jobConfig === void 0 ? void 0 : (_jobConfig$analyzed_f2 = jobConfig.analyzed_fields) === null || _jobConfig$analyzed_f2 === void 0 ? void 0 : _jobConfig$analyzed_f2.excludes, resultsField);
  const destIndex = (0, _common.getDestinationIndex)(jobConfig);
  if (dataViewErrorMessage !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      grow: false,
      hasShadow: false,
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.exploration.indexError', {
        defaultMessage: 'An error occurred loading the index data.'
      }),
      color: "danger",
      iconType: "cross"
    }, /*#__PURE__*/_react.default.createElement("p", null, dataViewErrorMessage, needsDestDataView ? /*#__PURE__*/_react.default.createElement(_data_view_prompt.DataViewPrompt, {
      destIndex: destIndex,
      color: "text"
    }) : null)));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, typeof (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.description) !== 'undefined' && (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.description) !== '' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), (columnsWithCharts.length > 0 || searchQuery !== _common.defaultSearchQuery) && dataView !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_exploration_query_bar.ExplorationQueryBar, {
    dataView: dataView,
    setSearchQuery: searchQueryUpdateHandler,
    query: query
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), typeof (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.id) === 'string' && /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSectionAnalytics, {
    jobId: jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.id
  }), typeof (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.id) === 'string' && scatterplotFieldOptions.length > 1 && /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSectionSplom, {
    fields: scatterplotFieldOptions,
    index: jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.dest.index,
    resultsField: jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.dest.results_field,
    searchQuery: searchQuery,
    query: query
  }), showLegacyFeatureInfluenceFormatCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.outlierExploration.legacyFeatureInfluenceFormatCalloutTitle', {
      defaultMessage: 'Color coded table cells based on feature influence are not available because the results index uses an unsupported legacy format. Please clone and rerun the job.'
    }),
    iconType: "pin"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSectionResults, {
    colorRange: showColorRange && !showLegacyFeatureInfluenceFormatCallout ? colorRange : undefined,
    indexData: outlierData,
    dataView: dataView,
    jobConfig: jobConfig,
    needsDestDataView: needsDestDataView,
    searchQuery: searchQuery
  }));
});
exports.OutlierExploration = OutlierExploration;