"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ErrorCallout = ({
  error
}) => {
  let errorCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.errorCallout.generalErrorTitle', {
      defaultMessage: 'An error occurred loading the data.'
    }),
    color: "danger",
    iconType: "cross"
  }, /*#__PURE__*/_react.default.createElement("p", null, error));
  // Job was created but not started so the destination index has not been created
  if (typeof error === 'string' && error.includes('index_not_found')) {
    errorCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.errorCallout.evaluateErrorTitle', {
        defaultMessage: 'An error occurred loading the data.'
      }),
      color: "danger",
      iconType: "cross"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.ml.dataframe.analytics.errorCallout.noIndexCalloutBody', {
      defaultMessage: 'The query for the index returned no results. Please make sure the destination index exists and contains documents.'
    })));
  } else if (typeof error === 'string' && error.includes('No documents found')) {
    // Job was started but no results have been written yet
    errorCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.errorCallout.noDataCalloutTitle', {
        defaultMessage: 'Empty index query result.'
      }),
      color: "primary"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.ml.dataframe.analytics.errorCallout.noDataCalloutBody', {
      defaultMessage: 'The query for the index returned no results. Please make sure the job has completed and the index contains documents.'
    })));
  } else if (typeof error === 'string' && error.includes('userProvidedQueryBuilder')) {
    // query bar syntax is incorrect
    errorCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.errorCallout.queryParsingErrorTitle', {
        defaultMessage: 'Unable to parse query.'
      }),
      color: "primary"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.ml.dataframe.analytics.errorCallout.queryParsingErrorBody', {
      defaultMessage: 'The query syntax is invalid and returned no results. Please check the query syntax and try again.'
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, errorCallout);
};
exports.ErrorCallout = ErrorCallout;