"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _create_data_view_form_row = require("@kbn/ml-data-view-utils/components/create_data_view_form_row");
var _shared = require("../shared");
var _page = require("../../page");
var _use_can_create_data_view = require("../../hooks/use_can_create_data_view");
var _use_data_view_time_fields = require("../../hooks/use_data_view_time_fields");
var _create_step_footer = require("../create_step_footer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateStep = ({
  actions,
  state,
  step,
  showCreateDataView = false
}) => {
  const canCreateDataView = (0, _use_can_create_data_view.useCanCreateDataView)();
  const {
    dataViewAvailableTimeFields,
    onTimeFieldChanged
  } = (0, _use_data_view_time_fields.useDataViewTimeFields)({
    actions,
    state
  });
  const {
    createAnalyticsJob,
    setFormState,
    startAnalyticsJob
  } = actions;
  const {
    isAdvancedEditorValidJson,
    isJobCreated,
    isJobStarted,
    isValid,
    requestMessages
  } = state;
  const {
    createDataView,
    destinationDataViewTitleExists,
    jobId,
    jobType,
    timeFieldName
  } = state.form;
  const [startChecked, setStartChecked] = (0, _react.useState)(true);
  const [creationTriggered, setCreationTriggered] = (0, _react.useState)(false);
  const [showProgress, setShowProgress] = (0, _react.useState)(false);
  if (step !== _page.ANALYTICS_STEPS.CREATE) return null;
  const handleCreation = async () => {
    setCreationTriggered(true);
    const creationSuccess = await createAnalyticsJob();
    if (creationSuccess === false) {
      setCreationTriggered(false);
    }
    if (startChecked && creationSuccess === true) {
      setShowProgress(true);
      startAnalyticsJob();
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlAnalyticsCreateJobWizardCreateStep active"
  }, !isJobCreated && !isJobStarted && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showCreateDataView && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_create_data_view_form_row.CreateDataViewForm, {
    canCreateDataView: canCreateDataView,
    createDataView: createDataView,
    dataViewTitleExists: destinationDataViewTitleExists,
    setCreateDataView: () => setFormState({
      createDataView: !createDataView
    }),
    dataViewAvailableTimeFields: dataViewAvailableTimeFields,
    dataViewTimeField: timeFieldName,
    onTimeFieldChanged: onTimeFieldChanged
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.startCheckboxHelpText', {
      defaultMessage: 'If unselected, job can be started later by returning to the jobs list.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "mlAnalyticsCreateJobWizardStartJobSwitch",
    name: "mlAnalyticsCreateJobWizardStartJobSwitch",
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.wizardStartCheckbox', {
      defaultMessage: 'Start immediately'
    }),
    checked: startChecked,
    onChange: e => {
      setStartChecked(e.target.checked);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: "mlAnalyticsCreateWizard__footerButton",
    disabled: !isValid || !isAdvancedEditorValidJson,
    onClick: handleCreation,
    fill: true,
    isLoading: creationTriggered,
    "data-test-subj": "mlAnalyticsCreateJobWizardCreateButton"
  }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.wizardCreateButton', {
    defaultMessage: 'Create'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_shared.Messages, {
    messages: requestMessages
  }), isJobCreated === true ? /*#__PURE__*/_react.default.createElement(_create_step_footer.CreateStepFooter, {
    jobId: jobId,
    jobType: jobType,
    showProgress: showProgress
  }) : null);
};
exports.CreateStep = CreateStep;