"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataSource = exports.DataSourceContextProvider = exports.DataSourceContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _queryString = require("query-string");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _index_utils = require("../../util/index_utils");
var _kibana = require("../kibana");
var _new_job_utils = require("../../jobs/new_job/utils/new_job_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataSourceContext = /*#__PURE__*/_react.default.createContext({});

/**
 * Context provider that resolves current data view and the saved search from the URL state.
 *
 * @param children
 * @constructor
 */
exports.DataSourceContext = DataSourceContext;
const DataSourceContextProvider = ({
  children
}) => {
  const [value, setValue] = (0, _react.useState)();
  const [error, setError] = (0, _react.useState)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    services: {
      data: {
        dataViews
      },
      savedSearch: savedSearchService,
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  const {
    index: dataViewId,
    savedSearchId
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const getDataViewAndSavedSearchCb = (0, _react.useCallback)(ssId => (0, _index_utils.getDataViewAndSavedSearchCallback)({
    savedSearchService,
    dataViewsService: dataViews
  })(ssId), [savedSearchService, dataViews]);

  /**
   * Resolve data view or saved search if exist in the URL.
   */
  const resolveDataSource = (0, _react.useCallback)(async () => {
    if (dataViewId === '') {
      throw new Error(_i18n.i18n.translate('xpack.ml.useResolver.errorIndexPatternIdEmptyString', {
        defaultMessage: 'dataViewId must not be empty string.'
      }));
    }
    let dataViewAndSavedSearch = {
      savedSearch: null,
      dataView: null
    };
    if (savedSearchId !== undefined) {
      dataViewAndSavedSearch = await getDataViewAndSavedSearchCb(savedSearchId);
    } else if (dataViewId !== undefined) {
      dataViewAndSavedSearch.dataView = await dataViews.get(dataViewId);
    }
    const {
      savedSearch,
      dataView
    } = dataViewAndSavedSearch;
    const {
      combinedQuery
    } = (0, _new_job_utils.createSearchItems)(uiSettings, dataView !== null ? dataView : undefined, savedSearch);
    return {
      combinedQuery,
      selectedDataView: dataView,
      selectedSavedSearch: savedSearch
    };
  }, [dataViewId, savedSearchId, uiSettings, dataViews, getDataViewAndSavedSearchCb]);
  (0, _react.useEffect)(() => {
    resolveDataSource().then(result => {
      setValue(result);
    }).catch(e => {
      setError(e);
    });
  }, [resolveDataSource]);
  if (!value && !error) return null;
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "error",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataSourceContext.errorTitle",
        defaultMessage: "Unable to fetch data view or saved search"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, error.message)
    });
  }
  return /*#__PURE__*/_react.default.createElement(DataSourceContext.Provider, {
    value: value
  }, children);
};
exports.DataSourceContextProvider = DataSourceContextProvider;
const useDataSource = () => {
  return (0, _react.useContext)(DataSourceContext);
};
exports.useDataSource = useDataSource;