"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteRuleModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for rendering a modal to confirm deletion of a rule.
 */

class DeleteRuleModal extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "deleteRule", () => {
      const {
        ruleIndex,
        deleteRuleAtIndex
      } = this.props;
      deleteRuleAtIndex(ruleIndex);
      this.closeModal();
    });
    (0, _defineProperty2.default)(this, "closeModal", () => {
      this.setState({
        isModalVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "showModal", () => {
      this.setState({
        isModalVisible: true
      });
    });
    this.state = {
      isModalVisible: false
    };
  }
  render() {
    let modal;
    if (this.state.isModalVisible) {
      modal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        title: _i18n.i18n.translate('xpack.ml.ruleEditor.deleteRuleModal.deleteRuleTitle', {
          defaultMessage: 'Delete rule?'
        }),
        onCancel: this.closeModal,
        onConfirm: this.deleteRule,
        buttonColor: "danger",
        cancelButtonText: _i18n.i18n.translate('xpack.ml.ruleEditor.deleteRuleModal.cancelButtonLabel', {
          defaultMessage: 'Cancel'
        }),
        confirmButtonText: _i18n.i18n.translate('xpack.ml.ruleEditor.deleteRuleModal.deleteButtonLabel', {
          defaultMessage: 'Delete'
        }),
        defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      color: "danger",
      onClick: () => this.showModal()
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.deleteRuleModal.deleteRuleLinkText",
      defaultMessage: "Delete rule"
    })), modal);
  }
}
exports.DeleteRuleModal = DeleteRuleModal;
DeleteRuleModal.propTypes = {
  ruleIndex: _propTypes.default.number.isRequired,
  deleteRuleAtIndex: _propTypes.default.func.isRequired
};