"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlPageControlsContext = exports.MlPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _mlDatePicker = require("@kbn/ml-date-picker");
var routes = _interopRequireWildcard(require("../../routing/routes"));
var _ml_page_wrapper = require("../../routing/ml_page_wrapper");
var _kibana = require("../../contexts/kibana");
var _use_active_route = require("../../routing/use_active_route");
var _use_doc_title = require("../../routing/use_doc_title");
var _page_header = require("../page_header/page_header");
var _side_nav = require("./side_nav");
var _ml = require("../../contexts/ml");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ML_APP_SELECTOR = '[data-test-subj="mlApp"]';
const MlPageControlsContext = /*#__PURE__*/(0, _react.createContext)({
  setHeaderActionMenu: () => {},
  headerPortal: (0, _reactReversePortal.createHtmlPortalNode)(),
  isHeaderMounted: false,
  setIsHeaderMounted: () => {}
});

/**
 * Main page component of the ML App
 * @constructor
 */
exports.MlPageControlsContext = MlPageControlsContext;
const MlPage = /*#__PURE__*/_react.default.memo(({
  pageDeps
}) => {
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const {
    services: {
      http: {
        basePath
      },
      mlServices: {
        httpService
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    showMLNavMenu
  } = (0, _ml.useEnabledFeatures)();
  const headerPortalNode = (0, _react.useMemo)(() => (0, _reactReversePortal.createHtmlPortalNode)(), []);
  const [isHeaderMounted, setIsHeaderMounted] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const subscriptions = new _rxjs.Subscription();
    subscriptions.add(httpService.getLoadingCount$.subscribe(v => {
      setIsLoading(v !== 0);
    }));
    return function cleanup() {
      subscriptions.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const routeList = (0, _react.useMemo)(() => Object.values(routes).map(routeFactory => routeFactory(navigateToPath, basePath.get())).filter(d => !d.disabled),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const activeRoute = (0, _use_active_route.useActiveRoute)(routeList);
  const rightSideItems = (0, _react.useMemo)(() => {
    return [...(activeRoute.enableDatePicker ? [/*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerWrapper, {
      isLoading: isLoading,
      width: "full"
    })] : [])];
  }, [activeRoute.enableDatePicker, isLoading]);
  (0, _use_doc_title.useDocTitle)(activeRoute);

  // The deprecated `KibanaPageTemplate` from`'@kbn/kibana-react-plugin/public'`
  // had a `pageBodyProps` prop where we could pass in the `data-test-subj` for
  // the `main` element. This is no longer available in the update template
  // imported from `'@kbn/shared-ux-page-kibana-template'`. The following is a
  // workaround to add the `data-test-subj` on the `main` element again.
  (0, _react.useEffect)(() => {
    const mlApp = document.querySelector(ML_APP_SELECTOR);
    if (mlApp && typeof (activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute['data-test-subj']) === 'string') {
      const mlAppMain = mlApp.querySelector('main');
      if (mlAppMain) {
        mlAppMain.setAttribute('data-test-subj', activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute['data-test-subj']);
      }
    }
  }, [activeRoute]);
  const sideNavItems = (0, _side_nav.useSideNavItems)(activeRoute);
  return /*#__PURE__*/_react.default.createElement(MlPageControlsContext.Provider, {
    value: {
      setHeaderActionMenu: pageDeps.setHeaderActionMenu,
      headerPortal: headerPortalNode,
      setIsHeaderMounted,
      isHeaderMounted
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    className: 'ml-app',
    "data-test-subj": 'mlApp',
    restrictWidth: false,
    solutionNav: showMLNavMenu ? {
      name: _i18n.i18n.translate('xpack.ml.plugin.title', {
        defaultMessage: 'Machine Learning'
      }),
      icon: 'machineLearningApp',
      items: sideNavItems
    } : undefined,
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeaderRenderer, null),
      rightSideItems,
      restrictWidth: false
    }
  }, /*#__PURE__*/_react.default.createElement(CommonPageWrapper, {
    headerPortal: headerPortalNode,
    setIsHeaderMounted: setIsHeaderMounted,
    pageDeps: pageDeps,
    routeList: routeList
  })));
});
exports.MlPage = MlPage;
const CommonPageWrapper = /*#__PURE__*/_react.default.memo(({
  pageDeps,
  routeList
}) => {
  const {
    services: {
      application
    }
  } = (0, _kibana.useMlKibana)();
  return (
    /*#__PURE__*/
    /** RedirectAppLinks intercepts all <a> tags to use navigateToUrl
     * avoiding full page reload **/
    _react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: {
        application
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      restrictWidth: false
    }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, routeList.map(route => {
      return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
        key: route.path,
        path: route.path,
        exact: true,
        render: props => {
          window.setTimeout(() => {
            pageDeps.setBreadcrumbs(route.breadcrumbs);
          });
          return /*#__PURE__*/_react.default.createElement(_ml_page_wrapper.MlPageWrapper, {
            path: route.path
          }, route.render(props, pageDeps));
        }
      });
    }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: "/overview"
    }))))
  );
});