"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../contexts/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineDetails = /*#__PURE__*/(0, _react.memo)(({
  handlePipelineConfigUpdate,
  modelId,
  pipelineName,
  pipelineNameError,
  pipelineDescription,
  targetField,
  targetFieldError
}) => {
  const {
    services: {
      docLinks: {
        links
      }
    }
  } = (0, _kibana.useMlKibana)();
  const handleConfigChange = (value, type) => {
    handlePipelineConfigUpdate({
      [type]: value
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.title', {
    defaultMessage: 'Create a pipeline'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.description",
    defaultMessage: "Build a {pipeline} to use the trained data frame analytics model - {modelId} - for inference.",
    values: {
      modelId: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, modelId),
      pipeline: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: links.ingest.pipelines
      }, "pipeline")
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.descriptionUsePipelines",
    defaultMessage: "Use {pipelineSimulateLink} or {reindexLink} to pass data into this pipeline. Predictions are stored in the Target field.",
    values: {
      reindexLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: links.upgradeAssistant.reindexWithPipeline
      }, "_reindex API"),
      pipelineSimulateLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: links.apis.simulatePipeline
      }, "pipeline/_simulate")
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.nameLabel', {
      defaultMessage: 'Name'
    }),
    helpText: !pipelineNameError && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.name.helpText', {
      defaultMessage: 'Pipeline names are unique within a deployment and can only contain letters, numbers, underscores, and hyphens.'
    })),
    error: pipelineNameError,
    isInvalid: pipelineNameError !== undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "mlTrainedModelsInferencePipelineNameInput",
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.namePlaceholder', {
      defaultMessage: 'Enter a unique name for this pipeline'
    }),
    value: pipelineName,
    onChange: e => handleConfigChange(e.target.value, 'pipelineName')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.descriptionLabel', {
      defaultMessage: 'Description'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.description.helpText', {
      defaultMessage: 'A description of what this pipeline does.'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    compressed: true,
    fullWidth: true,
    "data-test-subj": "mlTrainedModelsInferencePipelineDescriptionInput",
    placeholder: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.descriptionPlaceholder', {
      defaultMessage: 'Add a description of what this pipeline does.'
    }),
    value: pipelineDescription,
    onChange: e => handleConfigChange(e.target.value, 'pipelineDescription')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.targetFieldLabel', {
      defaultMessage: 'Target field (optional)'
    }),
    helpText: !targetFieldError && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.targetFieldHelpText",
      defaultMessage: "Field used to contain inference processor results. Defaults to {targetField}.",
      values: {
        targetField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'ml.inference.<processor_tag>')
      }
    }),
    error: targetFieldError,
    isInvalid: targetFieldError !== undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    "data-test-subj": "mlTrainedModelsInferencePipelineTargetFieldInput",
    value: targetField,
    onChange: e => handleConfigChange(e.target.value, 'targetField')
  }))))));
});
exports.PipelineDetails = PipelineDetails;