"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeRangeBar = TimeRangeBar;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TimeRangeBar({
  isRunning,
  timerange,
  ganttBarWidth
}) {
  const style = {
    width: timerange.widthPx,
    marginLeft: timerange.fromPx
  };
  const className = `mlJobSelector__ganttBar${isRunning ? ' mlJobSelector__ganttBarRunning' : ''}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: timerange.label
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "mlJobSelector__ganttBarBackEdge"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "mlJobSelector__ganttBarDashed",
    style: {
      width: `${ganttBarWidth}px`
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: style,
    className: className
  })));
}
TimeRangeBar.propTypes = {
  ganttBarWidth: _propTypes.PropTypes.number,
  isRunning: _propTypes.PropTypes.bool,
  timerange: _propTypes.PropTypes.shape({
    widthPx: _propTypes.PropTypes.number,
    label: _propTypes.PropTypes.string,
    fromPx: _propTypes.PropTypes.number
  })
};